/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.operation;

import com.streamscape.Trace;
import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.ConstantExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionArgumentsException;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.VariableAccessorExpression;
import com.streamscape.sef.evtrigger.function.expression.function.SysFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.operation.AbstractBinaryOperationExpression;
import com.streamscape.sef.evtrigger.function.fields.FunctionUnitAccessorExpression;
import com.streamscape.sef.evtrigger.function.statement.Variable;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.util.Stack;

public class AssignmentOperationExpression
extends AbstractBinaryOperationExpression {
    private boolean initializationAssignment;

    public AssignmentOperationExpression() {
        super("=", Priority.PRIORITY0, true);
    }

    public AssignmentOperationExpression(Variable variable, AbstractExpression expression, int beginPosition) {
        super("=", Priority.PRIORITY0, true);
        VariableAccessorExpression valueAccessorExpression = VariableAccessorExpression.create(variable);
        valueAccessorExpression.setBeginPosition(beginPosition);
        Stack<AbstractExpression> stack = new Stack<AbstractExpression>();
        stack.push(valueAccessorExpression);
        stack.push(expression);
        try {
            this.setArguments(stack);
        }
        catch (ExpressionArgumentsException exception) {
            exception.printStackTrace();
        }
    }

    public void setInitializationAssignment(boolean initializationAssignment) {
        this.initializationAssignment = initializationAssignment;
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        try {
            if (this.arguments[0] instanceof ConstantExpression) {
                return this.arguments[0].evaluate(context);
            }
            ValueAccessor leftResult = this.arguments[0].evaluate(context);
            ValueAccessor rightResult = this.arguments[1].evaluate(context);
            if (leftResult instanceof Variable) {
                ((Variable)leftResult).assignValue(rightResult.getValue(context), rightResult.getType(), context, this.initializationAssignment);
            } else {
                leftResult.assignValue(rightResult.getValue(context), rightResult.getType(), context);
            }
            return leftResult;
        }
        catch (ValueConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this, exception);
        }
    }

    @Override
    protected Object onEvaluateResult(Expression.ValueTypeResult result1, Expression.ValueTypeResult result2, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        throw new ExpressionExecutionException("onEvaluateResult method is not allowed in AssignmentOperationExpression.", this);
    }

    @Override
    protected void onValidateArguments() throws ExpressionArgumentsException {
        Variable variable;
        if (!(this.arguments[0] instanceof AssignableExpression)) {
            throw new ExpressionArgumentsException("Assignment operation expects two arguments, and first should be a variable.", this.arguments[0]);
        }
        if (this.arguments[0] instanceof VariableAccessorExpression && (variable = ((VariableAccessorExpression)this.arguments[0]).getVariable()).isFinal()) {
            if (!(this.arguments[1] instanceof ConstantExpression)) {
                throw new ExpressionArgumentsException("Final variable can be initialized with constant only.", this.arguments[0]);
            }
            if (variable.isInitialized()) {
                throw new ExpressionArgumentsException("Final variable can be initialized only once.", this.arguments[0]);
            }
            try {
                Expression.ValueTypeResult rightResult = this.arguments[1].evaluateValueType(null);
                variable.assignValue(rightResult.value, rightResult.type, null);
            }
            catch (Exception exception) {
                throw new ExpressionArgumentsException(exception.getMessage(), this);
            }
        }
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        SysFunctionsUnit.LookupFunction lookupFunction;
        super.validate(context);
        if (context.isCompleteMode() && this.arguments.length > 1 && this.arguments[0] instanceof VariableAccessorExpression && this.arguments[1] != null && this.arguments[1] instanceof SysFunctionsUnit.LookupFunction && (lookupFunction = (SysFunctionsUnit.LookupFunction)this.arguments[1]).getArguments() != null && lookupFunction.getArguments().size() == 1 && lookupFunction.getArguments().get(0) != null && lookupFunction.getArguments().get(0) instanceof ConstantExpression) {
            Variable variable = ((VariableAccessorExpression)this.arguments[0]).getVariable();
            Expression.ValueTypeResult rightResult = lookupFunction.evaluateValueType(null);
            try {
                variable.assignValue(rightResult.value, rightResult.type, null);
            }
            catch (ValueConversionException exception) {
                Trace.logException(this, exception, true);
            }
        }
    }

    @Override
    protected void onValidate(Type<?> type1, Type<?> type2) throws ExpressionExecutionException, TypeConversionException {
        type1.canConvert(type2);
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        Type<?> type;
        super.onCompile(context);
        try {
            this.arguments[0].getResultType().canConvert(this.arguments[1].getResultType());
        }
        catch (TypeConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this, exception);
        }
        if (this.arguments[1] instanceof FunctionUnitAccessorExpression && this.arguments[0] instanceof VariableAccessorExpression.VariableAccessorExpressionImpl && (type = ((FunctionUnitAccessorExpression)this.arguments[1]).narrowTypeFor(this.arguments[0].getResultType(), context)) != null && type != this.arguments[0].getResultType()) {
            ((VariableAccessorExpression.VariableAccessorExpressionImpl)this.arguments[0]).getVariable().narrowResultType(type);
        }
        return this;
    }
}

