/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.operation;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ReadOnlyValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ConstantExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionArgumentsException;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.util.Stack;

public abstract class AbstractOperationExpression
extends AbstractExpression {
    protected String operationName;
    protected AbstractExpression[] arguments;
    private int argumentsCount;
    private boolean resultTypeAsFirstArgument;

    public AbstractOperationExpression(String operationName, Priority priority, int argumentsCount, boolean resultTypeAsFirstArgument) {
        super(priority);
        this.operationName = operationName;
        this.argumentsCount = argumentsCount;
        this.arguments = new AbstractExpression[argumentsCount];
        this.resultTypeAsFirstArgument = resultTypeAsFirstArgument;
    }

    public void setArguments(Stack<AbstractExpression> arguments) throws ExpressionArgumentsException {
        if (arguments.size() < this.argumentsCount) {
            throw new ExpressionArgumentsException("Binary operation expects two arguments, but passed " + arguments.size() + ".", this);
        }
        for (int i = this.argumentsCount - 1; i >= 0; --i) {
            this.arguments[i] = arguments.pop();
            this.arguments[i].setParentExpression(this);
        }
        if (this.resultTypeAsFirstArgument) {
            this.setResultType(this.arguments[0].getResultType());
        }
        if (this.arguments.length > 1) {
            this.setBeginEndPositions(this.arguments[0].getBeginPosition(), this.arguments[this.argumentsCount - 1].getEndPosition());
        } else {
            this.setEndPosition(this.arguments[0].getEndPosition());
        }
        this.onValidateArguments();
    }

    @Override
    public Type<?> getResultType() {
        if (this.resultTypeAsFirstArgument) {
            this.setResultType(this.arguments[0].getResultType());
            return this.arguments[0].getResultType();
        }
        return super.getResultType();
    }

    protected void onValidateArguments() throws ExpressionArgumentsException {
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        Expression.ValueTypeResult[] results = new Expression.ValueTypeResult[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            results[i] = this.arguments[i].evaluateValueType(context);
        }
        this.onValidateArgumentValues(results);
        try {
            Object result = this.onEvaluateResult(results, context);
            if (this.resultTypeAsFirstArgument && this.getResultType() != null && this.getResultType() != results[0].type) {
                result = this.getResultType().convertValue(result, results[0].type);
            }
            return new ReadOnlyValueAccessor(result, this.getResultType() != null ? this.getResultType() : results[0].type);
        }
        catch (ValueConversionException exception) {
            String message = "Failed to evaluate '" + this.operationName + "' operation for argument";
            message = this.getArgumentsCount() == 1 ? message + " " + results[0].type.escapeValue(results[0].value) + "." : message + "s " + results[0].type.escapeValue(results[0].value) + " and " + results[1].type.escapeValue(results[1].value) + ".";
            message = message + " Cause: " + exception.getMessage();
            throw new ExpressionExecutionException(message, this, exception);
        }
    }

    protected void onValidateArgumentValues(Expression.ValueTypeResult[] results) {
    }

    protected abstract Object onEvaluateResult(Expression.ValueTypeResult[] var1, TriggerFunctionContext var2) throws ExpressionExecutionException, ValueConversionException;

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        try {
            for (AbstractExpression argument : this.arguments) {
                argument.validate(context);
            }
            this.onValidate(this.arguments);
        }
        catch (TypeConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this, exception);
        }
    }

    protected abstract void onValidate(AbstractExpression[] var1) throws ExpressionExecutionException, TypeConversionException;

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        boolean allConstant = true;
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].compile(context);
            if (this.arguments[i] instanceof ConstantExpression) continue;
            allConstant = false;
        }
        if (allConstant) {
            Expression.ValueTypeResult result = this.evaluateValueType(context);
            return this.createConstantExpressionWithClonePositional(result.value, result.type);
        }
        return this;
    }

    protected void checkArgumentsNotNull(Expression.ValueTypeResult ... values) throws ExpressionExecutionException {
        for (int i = 0; i < values.length; ++i) {
            if (values[i].value != null) continue;
            throw new ExpressionExecutionException("Null argument" + (i + 1) + " value is not allowed in '" + this.operationName + "' operation.", this.arguments[i]);
        }
    }

    protected void checkArgumentValueNotNull(Expression.ValueTypeResult value, int index) throws ExpressionExecutionException {
        if (value.value == null) {
            throw new ExpressionExecutionException("Null argument" + (index + 1) + " value is not allowed in '" + this.operationName + "' operation.", this.arguments[index]);
        }
    }

    protected void checkArgumentValueIsBoolean(Expression.ValueTypeResult value, int index) throws ExpressionExecutionException {
        this.checkArgumentValueNotNull(value, index);
        if (!(value.value instanceof Boolean)) {
            throw new ExpressionExecutionException("Argument" + (index + 1) + " value should be of type 'Boolean' in '" + this.operationName + "' operation.", this.arguments[index]);
        }
    }

    protected void checkTypesNotNull(Type<?> ... types) throws ExpressionExecutionException {
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != TypeFactory.NULLTYPE) continue;
            throw new ExpressionExecutionException("Null argument" + (i + 1) + " value is not allowed in '" + this.operationName + "' operation.", this.arguments[i]);
        }
    }

    protected void checkTypesAreBoolean(Type<?> ... types) throws ExpressionExecutionException {
        this.checkTypesNotNull(types);
        for (int i = 0; i < types.length; ++i) {
            try {
                TypeFactory.BOOLEAN.canConvert(types[i]);
                continue;
            }
            catch (TypeConversionException e) {
                throw new ExpressionExecutionException("Argument" + (i + 1) + " should be of type 'Boolean' in '" + this.operationName + "' operation.", this.arguments[i]);
            }
        }
    }

    public int getArgumentsCount() {
        return this.argumentsCount;
    }

    @Override
    protected void onToString(StringBuilder builder) {
        if (this.arguments.length > 1) {
            this.arguments[0].toString(builder);
        }
        builder.append(this.operationName);
        if (this.arguments.length > 1) {
            this.arguments[1].toString(builder);
        } else {
            this.arguments[0].toString(builder);
        }
    }
}

