/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.dispatcher.TriggerFunctionContextImpl;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ConstantExpression;
import com.streamscape.sef.evtrigger.function.expression.DisableExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.InvalidateExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;

public class ThisFunctionsUnit
extends AbstractFunctionsUnit {
    ThisFunctionsUnit() {
        super(FunctionsUnitType.THIS);
        this.registerFunction(GetCurrentEventFunction.class);
        this.registerFunction(SetCurrentEventFunction.class);
        this.registerFunction(HasCurrentEventFunction.class);
        this.registerFunction(SetCurrentDataspaceFunction.class);
        this.registerFunction(GetCurrentDataspaceFunction.class);
        this.registerFunction(DisableFunction.class);
        this.registerFunction(InvalidateFunction.class);
    }

    public static class GetCurrentEventFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = GetCurrentEventFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getCurrentEvent", TypeFactory.createEventType(), "Returns a refference to current event, null if current event is not set.");
        }

        public GetCurrentEventFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            return this.makeExpressionResult(context.getActionableEvent());
        }

        @Override
        protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
            AbstractExpression compiled = super.onCompile(context);
            if (context.getActionableEventType() != null) {
                String eventId;
                this.setResultType(context.getActionableEventType());
                if (context.getActionableEventType() instanceof EventType && (eventId = ((EventType)context.getActionableEventType()).getEventId()) != null) {
                    this.getParentBlock().getStatementContext().addUsedEventId(eventId);
                }
            }
            return compiled;
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            if (context.getActionableEventType() != null) {
                this.setResultType(context.getActionableEventType());
            }
        }
    }

    public static class SetCurrentEventFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = SetCurrentEventFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setCurrentEvent", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("event", TypeFactory.createEventType(), "new current event").build(), "Updates current event value. eventId should not be changed.");
        }

        public SetCurrentEventFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            Object value = ((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            Type<?> type = ((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).type;
            try {
                ((TriggerFunctionContextImpl)context).setActionableEvent((ImmutableEventDatagram)context.getActionableEventType().convertValue(value, type));
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException(exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            if (context.getActionableEventType() == null) {
                throw new ExpressionExecutionException("Set current event not allowed. Type of current event doesn't not set.", this);
            }
            try {
                context.getActionableEventType().canConvert(((AbstractExpression)this.arguments.get(0)).getResultType());
            }
            catch (TypeConversionException exception) {
                throw new ExpressionExecutionException(exception.getMessage(), this, exception);
            }
        }
    }

    public static class HasCurrentEventFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = HasCurrentEventFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("hasCurrentEvent", TypeFactory.BOOLEAN, "Returns true if current event is present.");
        }

        public HasCurrentEventFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            return this.makeExpressionResult(context.getActionableEvent() != null);
        }
    }

    public static class SetCurrentDataspaceFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = SetCurrentDataspaceFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setCurrentDataspace", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("dataspaceName", TypeFactory.STRING, "dataspace name in format <NodeName>://<Type>.<Name>, NodeName and Type are optional. Datasapce name should be constant").build(), "Sets specified dataspace as current.");
        }

        public SetCurrentDataspaceFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.getParentBlock().getStatementContext().getDefaultDataspaceFunctionsUnit().setDataspaceName((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value);
            return this.makeExpressionResult(null);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            if (!(this.arguments.get(0) instanceof ConstantExpression)) {
                throw this.argumentException(0, "Only final string allowed for the dataspaceName.");
            }
            String dataspaceName = (String)((ConstantExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
            this.getParentBlock().getStatementContext().getDefaultDataspaceFunctionsUnit().setDataspaceName(dataspaceName);
            try {
                this.getParentBlock().getStatementContext().getDefaultDataspaceFunctionsUnit().getDataspaceAccessor(context);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Failed to open dataspace connection to specified dataspace. Cause: " + exception.getMessage(), this, exception);
            }
        }
    }

    public static class GetCurrentDataspaceFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = GetCurrentDataspaceFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getCurrentDataspace", TypeFactory.DATASPACE, "Returns reference to the current dataspace. New Dataspace accessor and session will be created on each call.");
        }

        public GetCurrentDataspaceFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            return this.makeExpressionResult(this.getParentBlock().getStatementContext().getDefaultDataspaceFunctionsUnit());
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class DisableFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = DisableFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("disable", TypeFactory.VOIDTYPE, "Disables this trigger if executed inside the trigger.");
        }

        public DisableFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            throw new DisableExpressionExecutionException(this);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class InvalidateFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = InvalidateFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("invalidate", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("error", TypeFactory.STRING, "error description").build(), "Unloads and invalidates trigger.");
        }

        public InvalidateFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            throw new InvalidateExpressionExecutionException((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value, this);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }
}

