/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.Trace;
import com.streamscape.ds.trigger.event.SysFunctionUnit;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ReadOnlyValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.DataspaceFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.expression.function.RuntimeFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.ServiceFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.operation.AssignmentOperationExpression;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class SysFunctionsUnit
extends AbstractFunctionsUnit {
    SysFunctionsUnit() {
        super(FunctionsUnitType.SYS);
        this.registerFunction(LookupFunction.class);
        this.registerFunction(GetGlobalVariableFunction.class);
        this.registerFunction(SetGlobalVariableFunction.class);
        this.registerFunction(GetSystemVariableFunction.class);
        this.registerFunction(GetHostnameFunction.class);
        this.registerFunction(QueryFunction.class);
        this.registerFunction(GetFunction.class);
        this.registerFunction(GetTypeFunction.class);
    }

    public static class LookupFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = LookupFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("lookup", TypeFactory.createObjectType(), FunctionMetaData.Arguments.builder().add("name", TypeFactory.STRING, "name of Service or Dataspace in format <NodeName>://<Type>.<Name>, NodeName and Type are optional").build(), "Finds and returns reference to Dataspace/Service component with specified name.\nType of this component depends on variable type in assignment operation.\nIf Dataspace accessor is request then new dataspace session to specified dataspace will be created internally.");
        }

        LookupFunction() {
            super(metadata);
        }

        public static FunctionsUnit createFunctionUnit(AbstractExpression parent, String componentName) {
            AbstractFunctionsUnit functionsUnit = null;
            if (parent.getResultType().getType() == Types.DATASPACE) {
                functionsUnit = new DataspaceFunctionsUnit();
                functionsUnit.setDataspaceName(componentName);
            } else if (parent.getResultType().getType() == Types.SERVICE) {
                functionsUnit = new ServiceFunctionsUnit();
                ((ServiceFunctionsUnit)functionsUnit).setServiceName(componentName);
            } else if (parent.getResultType().getType() == Types.RUNTIME) {
                functionsUnit = new RuntimeFunctionsUnit();
                ((RuntimeFunctionsUnit)functionsUnit).setNodeName(componentName);
            }
            return functionsUnit;
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String componentName = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            FunctionsUnit functionsUnit = LookupFunction.createFunctionUnit(this.getParentExpression(), componentName);
            if (functionsUnit == null) {
                throw new ExpressionExecutionException("Invalid type " + String.valueOf(this.getParentExpression().getResultType()) + ". Dataspace, Service and Runtime are allowed only.", this);
            }
            return new ReadOnlyValueAccessor(functionsUnit, this.getParentExpression().getResultType());
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            if (this.getParentExpression() == null || !(this.getParentExpression() instanceof AssignmentOperationExpression)) {
                throw new ExpressionExecutionException("sys.lookup() function should be called inside assignment operation or cast operation.", this);
            }
            Type<?> resultType = this.getParentExpression().getResultType();
            if (resultType == null || resultType.getType() != Types.DATASPACE && resultType.getType() != Types.SERVICE && resultType.getType() != Types.RUNTIME) {
                throw new ExpressionExecutionException("Cannot cast to " + String.valueOf(resultType) + ". Dataspace, Service and Runtime are allowed only.", this);
            }
        }
    }

    public static class GetGlobalVariableFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = GetGlobalVariableFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getGlobalVariable", TypeFactory.STRING, FunctionMetaData.Arguments.builder().add("name", TypeFactory.STRING, "name of global variable in format [PoolName].[VariableName].").build(), "Returns a value of global variable, or null if such variable does not exist.");
        }

        GetGlobalVariableFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            String variableName = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            String value = null;
            try {
                value = RuntimeContext.getInstance().getGlobalVariableFactory().getVariable(variableName);
            }
            catch (Exception exception) {
                Trace.logError(this, "Unable to resolve '" + variableName + "' global variable.");
            }
            return this.makeExpressionResult(value);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class SetGlobalVariableFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = SetGlobalVariableFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setGlobalVariable", TypeFactory.BOOLEAN, FunctionMetaData.Arguments.builder().add("name", TypeFactory.STRING, "name of global variable in format [PoolName].[VariableName]").add("value", TypeFactory.STRING, "value of global variable").build(), "Sets a value of system variable. Returns true if set was success, false otherwise.");
        }

        SetGlobalVariableFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            String variableName = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            String variableValue = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            try {
                RuntimeContext.getInstance().getGlobalVariableFactory().setVariable(variableName, variableValue);
            }
            catch (Exception exception) {
                Trace.logError(this, "Unable to set '" + variableName + "' global variable.");
                Trace.logException(this, exception, false);
                return this.makeExpressionResult(false);
            }
            return this.makeExpressionResult(true);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class GetSystemVariableFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = GetSystemVariableFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getSystemVariable", TypeFactory.STRING, FunctionMetaData.Arguments.builder().add("name", TypeFactory.STRING, "name of system variable").build(), "Returns a value of system variable, or null if such variable does not exist.");
        }

        GetSystemVariableFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            String variableName = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            return this.makeExpressionResult(System.getProperty(variableName));
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class GetHostnameFunction
    extends AbstractFunctionExpression {
        private static Method GET_BY_INDEX_METHOD;
        public static final FunctionMetaData metadata;

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getHostname", TypeFactory.STRING, FunctionMetaData.Arguments.builder().addOptional("index", TypeFactory.INT, "interface index").build(), "Returns value of system property 'hostname' or interface with specified index.\nIf function has argument then it determines interface index, otherwise it determines value of system property 'hostname'.");
        }

        GetHostnameFunction() {
            super(metadata);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String result = null;
            if (this.argumentsValues.size() > 0) {
                NetworkInterface nic;
                int interfaceIndex = (Integer)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
                if (GET_BY_INDEX_METHOD == null) {
                    throw new ExpressionExecutionException("Obtaining interface with index '" + interfaceIndex + "' failed. Cause: NetworkInterface.getByIndex method not initialized.", this);
                }
                try {
                    nic = (NetworkInterface)GET_BY_INDEX_METHOD.invoke(null, interfaceIndex);
                }
                catch (Exception exception) {
                    throw new ExpressionExecutionException("Obtaining interface with index '" + interfaceIndex + "'. failed.", this, exception);
                }
                if (nic == null) throw new ExpressionExecutionException("Interface with index '" + interfaceIndex + "' does not exist.", this);
                Enumeration<InetAddress> addresses = nic.getInetAddresses();
                while (result == null && addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    result = address.getHostAddress();
                }
                if (result != null) return this.makeExpressionResult(result);
                Trace.logError(this, "Interface with index " + interfaceIndex + " '" + nic.getDisplayName() + "' does not have inet addresses.");
                return this.makeExpressionResult(result);
            }
            result = System.getProperty("hostname");
            return this.makeExpressionResult(result);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }

        static {
            try {
                GET_BY_INDEX_METHOD = NetworkInterface.class.getDeclaredMethod("getByIndex", Integer.TYPE);
                if (GET_BY_INDEX_METHOD != null) {
                    GET_BY_INDEX_METHOD.setAccessible(true);
                }
            }
            catch (Exception exception) {
                Trace.logError(GetHostnameFunction.class, "Initialization of NetworkInterface.getByIndex method failed. Cause: " + String.valueOf(exception));
            }
            metadata = GetHostnameFunction.createMetaData();
        }
    }

    public static class QueryFunction
    extends AbstractGetQueryFunction {
        public static final FunctionMetaData metadata = QueryFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("query", TypeFactory.createSemanticTypeType(RowSet.class.getSimpleName(), RowSet.class.getName()), FunctionMetaData.Arguments.builder().add("query", TypeFactory.STRING, "slang query or semicolon delimited queries ").build(), "Executes slang query(queries) in parent(runtime or service) context in system session. RowSet result of last query returned.\nIf result is error result exception thrown. If result is not RowSet then RowSet with one column Response and one row returned.\nIf left side operand type is not RowSet then result is tried to be cast to left side type.");
        }

        QueryFunction() {
            super(metadata);
        }

        @Override
        protected Object convertSLResponse(TriggerFunctionContext context, SLResponse slResponse) throws SQLException {
            RowSet rowSet = null;
            if (slResponse.getRowSet() != null) {
                rowSet = slResponse.getRowSet();
            } else {
                RowMetaData meta = new RowMetaData();
                meta.addColumn("Response", SQLType.STRING);
                rowSet = new RowSet(meta);
                if (slResponse.getText() != null) {
                    rowSet.addToRowSet(new Object[]{slResponse.getText()});
                } else {
                    rowSet.addToRowSet(new Object[]{"OK"});
                }
            }
            return rowSet;
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class GetFunction
    extends AbstractGetQueryFunction {
        public static final FunctionMetaData metadata = GetFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("get", TypeFactory.createSemanticTypeType("object", Object.class.getName()), FunctionMetaData.Arguments.builder().add("query", TypeFactory.STRING, "slang query or semicolon delimited queries ").build(), "Executes slang query in runtime context.\nReturns the object depending on return value of the last query:\n   - if value is object this object is returned\n   - if value is RowSet with one row and one column the object from first row and first column is returned\n   - if there is a string object it is tried to be deserialized to left side object type\n   - if the is a RowSet with more than one row or more than one column this RowSet is returned\nIf result is error result exception thrown.");
        }

        GetFunction() {
            super(metadata);
        }

        @Override
        protected Object convertSLResponse(TriggerFunctionContext context, SLResponse slResponse) throws SQLException, SerializerException {
            String javaClassName = this.getParentExpression() != null && this.getParentExpression().getResultType() != null ? this.getParentExpression().getResultType().getJavaClassName() : null;
            Class<?> clazz = null;
            if (javaClassName != null && javaClassName.length() > 0) {
                try {
                    clazz = Class.forName(javaClassName, false, context.getFabricContext().getSystemClassLoaderChain());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (slResponse.getObject() != null) {
                return slResponse.getObject();
            }
            return SysFunctionUnit.GetEntry.convertSLResponseTextOrRowSet(clazz, slResponse);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class GetTypeFunction
    extends AbstractFunctionExpression {
        private static final String UNDEFINED = "undefined";
        public static final FunctionMetaData metadata = GetTypeFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getType", TypeFactory.STRING, FunctionMetaData.Arguments.builder().add("object", TypeFactory.createObjectType(), "any object").build(), "Defines semantic type of specified object. If no semantic type exists or value is null returns 'undefined'.");
        }

        GetTypeFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            SemanticType semanticType;
            String result = UNDEFINED;
            Object object = ((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            if (object != null && (semanticType = context.lookupSemanticTypeByClass(object.getClass().getName())) != null) {
                result = semanticType.getTypeName();
            }
            return this.makeExpressionResult(result);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    static abstract class AbstractGetQueryFunction
    extends AbstractFunctionExpression {
        AbstractGetQueryFunction(FunctionMetaData metadata) {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String queries = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            if (queries == null || queries.length() <= 0) {
                throw this.argumentException(0, "Query should be not null and not empty.");
            }
            ArrayList<String> operations = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(queries, ";");
            while (tokenizer.hasMoreTokens()) {
                operations.add(tokenizer.nextToken().trim());
            }
            try {
                Object rowSet = null;
                Object response = null;
                for (int i = 0; i < operations.size(); ++i) {
                    String operation = (String)operations.get(i);
                    Trace.logDebug(this, "Executing SLANG operation '{}'", operation);
                    SLResponse slResponse = context.getSLSession().slangRequest(operation, 0L);
                    if (!slResponse.isOK()) {
                        String errorMessage = "Execution of SLANG operation '" + operation + "' failed.";
                        throw slResponse.getException() != null ? new ExpressionExecutionException(errorMessage, this, slResponse.getException()) : new ExpressionExecutionException(errorMessage + " Cause: " + slResponse.getText(), this);
                    }
                    if (i != operations.size() - 1) continue;
                    response = this.convertSLResponse(context, slResponse);
                }
                return this.makeExpressionResult(response);
            }
            catch (Exception exception) {
                if (exception instanceof ExpressionExecutionException) {
                    throw (ExpressionExecutionException)exception;
                }
                throw new ExpressionExecutionException("Execution of SLANG operation failed.", this, exception);
            }
        }

        protected abstract Object convertSLResponse(TriggerFunctionContext var1, SLResponse var2) throws SQLException, SerializerException;

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }
}

