/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.parser.completion.ServiceEventHandlerCompleter;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import java.io.Closeable;
import java.io.IOException;

public class ServiceFunctionsUnit
extends AbstractFunctionsUnit
implements Closeable {
    private String serviceName;
    private ServiceAccessor serviceAccessor;

    public ServiceFunctionsUnit() {
        super(FunctionsUnitType.SERVICE);
        this.registerFunction(InvokeRequestFunction.class);
    }

    public void setServiceName(String serviceName) {
        if (this.serviceName != null && !this.serviceName.equals(serviceName)) {
            this.forceClose();
        }
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceAccessor getServiceAccessor(TriggerFunctionContext context) throws Exception {
        if (this.serviceAccessor == null) {
            this.serviceAccessor = context.createServiceAccessor(this.serviceName);
        }
        return this.serviceAccessor;
    }

    @Override
    public void close() throws IOException {
        this.forceClose();
    }

    public void forceClose() {
        if (this.serviceAccessor != null) {
            this.serviceAccessor.close();
        }
    }

    @Override
    public DSLCompletion complete(TriggerFunctionParserContext context, String prefix) {
        DSLCompletion completion1 = super.complete(context, prefix);
        DSLCompletion completion2 = this.createServiceEventHandlerCompletion(context).complete(prefix);
        return CompoundCompleter.mergeCompletions("", completion1, completion2);
    }

    private ServiceEventHandlerCompleter createServiceEventHandlerCompletion(TriggerFunctionParserContext context) {
        return new ServiceEventHandlerCompleter(null, this.serviceName, (RuntimeContext)((TriggerFunctionParserContextImpl)context).getFabricContext());
    }

    @Override
    public AbstractFunctionExpression lookupFunction(String name, TriggerFunctionParserContext context) {
        AbstractFunctionExpression function = super.lookupFunction(name, context);
        if (function != null) {
            return function;
        }
        return this.createServiceEventHandlerFunction(name, context);
    }

    public AbstractFunctionExpression createServiceEventHandlerFunction(String name, TriggerFunctionParserContext context) {
        EventHandler eventHandler = null;
        try {
            eventHandler = this.createServiceEventHandlerCompletion(context).getEventHandlersProvider().lookupEventHandler(name);
        }
        catch (Exception exception) {
            return null;
        }
        ServiceEventHandlerFunction function = new ServiceEventHandlerFunction(eventHandler, context);
        function.setFunctionsUnit(this);
        return function;
    }

    public static class InvokeRequestFunction
    extends AbstractServiceFunction {
        public static String NAME = "invokeRequest";
        public static final FunctionMetaData metadata = InvokeRequestFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData(NAME, TypeFactory.createObjectType(), FunctionMetaData.Arguments.builder().add("handlerName", TypeFactory.STRING, "Service handler name.").add("object", TypeFactory.createObjectType(), "Service handler parameter.").addOptional("timeout", TypeFactory.LONG, "Timeout in milliseconds.").build(), "Invokes service method handler.");
        }

        public InvokeRequestFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            String handlerName = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            Object object = ((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            long timeout = (Long)(this.argumentsValues.size() > 2 ? this.arguments.get(2) : Long.valueOf(-1L));
            return this.makeExpressionResult(this.invokeServiceRequest(handlerName, object, timeout, context));
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class ServiceEventHandlerFunction
    extends AbstractServiceFunction {
        private static FunctionMetaData createMetaData(EventHandler eventHandler, TriggerFunctionParserContext context) {
            Type<Object> requestType = TypeFactory.createObjectType();
            Type<Object> responseType = TypeFactory.createObjectType();
            try {
                requestType = TypeFactory.createType(eventHandler.getRequestSemanticType(), context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                responseType = TypeFactory.createType(eventHandler.getResponseSemanticType(), context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new FunctionMetaData(eventHandler.getHandlerName(), responseType, FunctionMetaData.Arguments.builder().add("o", requestType, "Event handler incoming object.").addOptional("timeout", TypeFactory.LONG, "Request timeout.").build(), "Invokes event handler with name '" + String.valueOf(eventHandler) + "'.");
        }

        protected ServiceEventHandlerFunction(EventHandler eventHandler, TriggerFunctionParserContext context) {
            super(ServiceEventHandlerFunction.createMetaData(eventHandler, context));
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String handlerName = this.getMetaData().getFunctionName();
            Object object = ((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            long timeout = (Long)(this.argumentsValues.size() > 2 ? this.arguments.get(2) : Long.valueOf(-1L));
            return this.makeExpressionResult(this.invokeServiceRequest(handlerName, object, timeout, context));
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    static abstract class AbstractServiceFunction
    extends AbstractFunctionExpression {
        protected AbstractServiceFunction(FunctionMetaData metadata) {
            super(metadata);
        }

        protected ServiceAccessor getServiceAccessor(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                return ((ServiceFunctionsUnit)this.getFunctionsUnit()).getServiceAccessor(context);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Unable to create service accessor to '" + ((ServiceFunctionsUnit)this.getFunctionsUnit()).getServiceName() + "'. Cause: " + exception.getMessage(), this, exception);
            }
        }

        protected Object invokeServiceRequest(String handlerName, Object object, long timeout, TriggerFunctionContext context) throws ExpressionExecutionException {
            Object result = null;
            try {
                result = timeout >= 0L ? this.getServiceAccessor(context).invokeServiceRequest(handlerName, object, timeout) : this.getServiceAccessor(context).invokeServiceRequest(handlerName, object);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Unable to invoke service event handler. Cause: " + exception.getMessage(), this, exception);
            }
            return result;
        }
    }
}

