/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ConstantExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.fields.MethodAccessorExpression;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.scheduler.Scheduler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

class SchedulerFunctionsUnit
extends FunctionsUnit {
    private Set<String> methods;

    SchedulerFunctionsUnit() {
        super(FunctionsUnitType.SCHEDULER);
    }

    private synchronized void initMethods() {
        if (this.methods == null) {
            this.methods = new HashSet<String>();
            for (Class clazz = Scheduler.class; clazz != null; clazz = clazz.getSuperclass()) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    this.methods.add(method.getName());
                }
            }
        }
    }

    @Override
    public Set<String> listFunctionNames(TriggerFunctionParserContext context) {
        this.initMethods();
        return this.methods;
    }

    @Override
    public AbstractFunctionExpression lookupFunction(String name, TriggerFunctionParserContext context) {
        this.initMethods();
        if (this.methods.contains(name)) {
            return new SchedulerFunction(name);
        }
        return null;
    }

    public static class SchedulerFunction
    extends AbstractFunctionExpression {
        private static FunctionMetaData createMetaData(String name) {
            return new FunctionMetaData(name, TypeFactory.createObjectType(), "See Scheduler javadoc.");
        }

        protected SchedulerFunction(String name) {
            super(SchedulerFunction.createMetaData(name));
        }

        @Override
        protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
            return new MethodAccessorExpression(new ConstantExpression(RuntimeContext.getInstance().getScheduler(), TypeFactory.createObjectType()), this.getFunctionName(), this.arguments).compile(context);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            throw new ExpressionExecutionException("evaluate method is not allowed for SchedulerFunction.", this);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            throw new ExpressionExecutionException("evaluate method is not allowed for SchedulerFunction.", this);
        }
    }
}

