/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.slang.SLSession;
import java.io.Closeable;
import java.io.IOException;

public class RuntimeFunctionsUnit
extends AbstractFunctionsUnit
implements Closeable {
    private String nodeName;
    private SLSession slSession;

    public RuntimeFunctionsUnit() {
        super(FunctionsUnitType.RUNTIME);
        this.registerFunction(QueryFunction.class);
    }

    public void setNodeName(String nodeName) {
        if (this.nodeName != null && !this.nodeName.equals(nodeName)) {
            this.forceClose();
        }
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public SLSession getSLSession(TriggerFunctionContext context) throws Exception {
        if (this.slSession == null) {
            this.slSession = context.createSLSession(this.nodeName);
        }
        return this.slSession;
    }

    @Override
    public void close() throws IOException {
        this.forceClose();
    }

    public void forceClose() {
        if (this.slSession != null) {
            this.slSession.close();
        }
    }

    public static class QueryFunction
    extends AbstractServiceFunction {
        public static String NAME = "query";
        public static final FunctionMetaData metadata = QueryFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData(NAME, TypeFactory.createSemanticTypeType(SLResponse.class), FunctionMetaData.Arguments.builder().add("query", TypeFactory.STRING, "Slang query").build(), "Invokes slang query.");
        }

        public QueryFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            String query = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            try {
                return this.makeExpressionResult(this.getSLSession(context).slangRequest(query, 0L));
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Unable to invoke service request. Cause: " + exception.getMessage(), this, exception);
            }
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    static abstract class AbstractServiceFunction
    extends AbstractFunctionExpression {
        protected AbstractServiceFunction(FunctionMetaData metadata) {
            super(metadata);
        }

        protected SLSession getSLSession(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                return ((RuntimeFunctionsUnit)this.getFunctionsUnit()).getSLSession(context);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Unable to create slang session to '" + ((RuntimeFunctionsUnit)this.getFunctionsUnit()).getNodeName() + "'. Cause: " + exception.getMessage(), this, exception);
            }
        }
    }
}

