/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;

public class RepositoryFunctionsUnit
extends AbstractFunctionsUnit {
    RepositoryFunctionsUnit() {
        super(FunctionsUnitType.REPOSITORY);
        this.registerFunction(LookupFunction.class);
    }

    public static class LookupFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = LookupFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("lookup", TypeFactory.createObjectType(), FunctionMetaData.Arguments.builder().add("namespace", TypeFactory.STRING, "namespace of the object to lookup").add("name", TypeFactory.STRING, "name of the object to lookup").build(), "Looks up the specified object in the specified namespace of the repository.");
        }

        LookupFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String namespace = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            String objectName = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            try {
                return this.makeExpressionResult(RuntimeContext.getInstance().getRepositoryAccessor().lookupObject(namespace, objectName));
            }
            catch (Exception error) {
                throw new ExpressionExecutionException("Unable to lookup object '" + objectName + "' from '" + namespace + "' namespace. " + error.getMessage(), this);
            }
        }
    }
}

