/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.ExecResult;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.lexer.Token;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class OsFunctionsUnit
extends AbstractFunctionsUnit {
    OsFunctionsUnit() {
        super(FunctionsUnitType.OS);
        this.registerFunction(ExecFunction.class);
    }

    public static class ExecFunction
    extends AbstractFunctionExpression {
        public static String NAME = "exec";
        public static final FunctionMetaData metadata = ExecFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData(NAME, TypeFactory.createSemanticTypeType(ExecResult.class), FunctionMetaData.Arguments.builder().add("command", TypeFactory.STRING, "command with arguments").addOptional("env", TypeFactory.createArrayType(TypeFactory.STRING), "environment variable in format <name>=<value>").addOptional("directory", TypeFactory.STRING, "home directory").build(), "Executes system command.");
        }

        public ExecFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            OsCommandExecutor.Builder builder = OsCommandExecutor.builder();
            builder.command((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value);
            builder.env(this.argumentsValues.size() > 1 ? (String[])((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value : null);
            builder.homeDirectory(this.argumentsValues.size() > 2 ? (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).value : null);
            return this.makeExpressionResult(builder.build().execute());
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class StreamReader
    extends SingleTaskWorker {
        private BufferedReader inputReader;
        private StringBuffer buffer;
        private final Object mutex = new Object();
        private volatile boolean mutexWasInterrupted = false;

        public StreamReader(String type) {
            super("ExecProcessReader." + type, "Exec process output stream reader.");
            this.buffer = new StringBuffer();
        }

        public void setInputStream(InputStream inputStream) {
            this.inputReader = new BufferedReader(new InputStreamReader(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            while (this.isStarted() || this.mutexWasInterrupted) {
                try {
                    String line = null;
                    while ((line = this.inputReader.readLine()) != null) {
                        this.buffer.append(line).append("\n");
                    }
                    if (this.mutexWasInterrupted) break;
                    Object object = this.mutex;
                    synchronized (object) {
                        try {
                            this.mutex.wait(200L);
                        }
                        catch (InterruptedException exception) {
                            this.mutexWasInterrupted = true;
                        }
                    }
                }
                catch (IOException exception) {
                    Trace.logError(this, "Failed to read from stream. Cause: " + exception.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptMutex() {
            Object object = this.mutex;
            synchronized (object) {
                this.mutexWasInterrupted = true;
                this.mutex.notifyAll();
            }
        }

        public void append(String message) {
            this.buffer.append(message);
        }

        public String getBuffer() {
            return this.buffer.length() > 0 ? this.buffer.toString() : null;
        }
    }

    public static class OsCommandExecutor {
        private String command;
        private String homeDirectory;
        private String[] env;

        private OsCommandExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecResult execute() {
            File homeDirectoryFile = null;
            if (!(this.homeDirectory == null || (homeDirectoryFile = new File(this.homeDirectory)).exists() && homeDirectoryFile.isDirectory())) {
                return ExecResult.homeDirectoryDoesntExist(this.homeDirectory);
            }
            int code = 0;
            StreamReader outputStreamReader = new StreamReader("Output");
            StreamReader errorStreamReader = new StreamReader("Error");
            Process process = null;
            String errorMessageToAppend = null;
            try {
                ArrayList<String> cmdarray = new ArrayList<String>();
                ProcessBuilder.Redirect redirect = this.splitCommand(this.command, cmdarray);
                ProcessBuilder processBuilder = new ProcessBuilder(cmdarray);
                processBuilder.environment().putAll(this.splitEnv(this.env));
                processBuilder.directory(homeDirectoryFile);
                if (redirect != null) {
                    processBuilder.redirectOutput(redirect);
                }
                try {
                    process = processBuilder.start();
                }
                catch (Exception exception) {
                    ExecResult execResult = ExecResult.execCallFailed(exception);
                    outputStreamReader.interruptMutex();
                    errorStreamReader.interruptMutex();
                    outputStreamReader.join(2000L);
                    errorStreamReader.join(2000L);
                    return execResult;
                }
                outputStreamReader.setInputStream(process.getInputStream());
                outputStreamReader.start();
                errorStreamReader.setInputStream(process.getErrorStream());
                errorStreamReader.start();
                code = process.waitFor();
            }
            catch (InterruptedException exception) {
                code = ExecResult.EXECUTION_INTERRUPTED;
                errorMessageToAppend = exception.getMessage();
            }
            catch (Exception exception) {
                code = ExecResult.EXECUTION_EXCEPTION;
                errorMessageToAppend = exception.getMessage();
            }
            finally {
                outputStreamReader.interruptMutex();
                errorStreamReader.interruptMutex();
                outputStreamReader.join(2000L);
                errorStreamReader.join(2000L);
            }
            if (errorMessageToAppend != null) {
                errorStreamReader.append(errorMessageToAppend);
            }
            return ExecResult.builder().setCode(code).setError(errorStreamReader.getBuffer()).setOutput(outputStreamReader.getBuffer()).build();
        }

        private ProcessBuilder.Redirect splitCommand(String command, List<String> cmdarray) {
            char c;
            ProcessBuilder.Redirect redirect = null;
            for (int i = command.length() - 1; i >= 0 && "'\"".indexOf(c = command.charAt(i)) == -1; --i) {
                if (c != '>') continue;
                if (i + 1 < command.length()) {
                    if (c > '\u0000' && command.charAt(i - 1) == '>') {
                        redirect = ProcessBuilder.Redirect.appendTo(new File(command.substring(i + 1).trim()));
                        --i;
                    } else {
                        redirect = ProcessBuilder.Redirect.to(new File(command.substring(i + 1).trim()));
                    }
                }
                if (i <= 0) break;
                command = command.substring(0, i);
                break;
            }
            try {
                Token<LexerFactory.DummyTokenType> token;
                Lexer<LexerFactory.DummyTokenType> lexer = LexerFactory.createLexer(command);
                int oldPosition = 0;
                while ((token = lexer.readToken()).getCommonType() != CommonTokenType.BUFFER_END) {
                    if (token.getCommonType() != CommonTokenType.STRING_LITERAL) continue;
                    if (lexer.getCurrentTokenPosition() > oldPosition) {
                        cmdarray.addAll(this.splitBySpaces(lexer.substring(oldPosition, lexer.getCurrentTokenPosition())));
                    }
                    cmdarray.add(token.getValue());
                    oldPosition = lexer.getCurrentPosition();
                }
                if (oldPosition < lexer.getLength()) {
                    cmdarray.addAll(this.splitBySpaces(lexer.substring(oldPosition, lexer.getLength())));
                }
            }
            catch (LexerException exception) {
                Trace.logError(this, "Failed to create lexer. Cause: " + String.valueOf(exception));
                cmdarray.addAll(this.splitBySpaces(command));
            }
            return redirect;
        }

        private List<String> splitBySpaces(String command) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(command);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
            return result;
        }

        private Map<String, String> splitEnv(String[] envp) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (envp != null) {
                for (String envstring : envp) {
                    int eqlsign;
                    if (envstring.indexOf(0) != -1) {
                        envstring = envstring.replaceFirst("\u0000.*", "");
                    }
                    if ((eqlsign = envstring.indexOf(61)) == -1) continue;
                    result.put(envstring.substring(0, eqlsign), envstring.substring(eqlsign + 1));
                }
            }
            return result;
        }

        public String getCommand() {
            return this.command;
        }

        public String getHomeDirectory() {
            return this.homeDirectory;
        }

        public String[] getEnv() {
            return this.env;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String command;
            private String homeDirectory;
            private String[] env;

            private Builder() {
            }

            public Builder command(String command) {
                this.command = command;
                return this;
            }

            public Builder homeDirectory(String homeDirectory) {
                this.homeDirectory = homeDirectory;
                return this;
            }

            public Builder env(String[] env) {
                this.env = env;
                return this;
            }

            public OsCommandExecutor build() {
                OsCommandExecutor executor = new OsCommandExecutor();
                executor.command = this.command;
                executor.homeDirectory = this.homeDirectory;
                executor.env = this.env;
                return executor;
            }
        }
    }
}

