/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.omf.serializer.AbstractSerializer;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.sef.FabricManagedComponent;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.trace.ComponentLogger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class LogFunctionsUnit
extends AbstractFunctionsUnit {
    LogFunctionsUnit() {
        super(FunctionsUnitType.LOG);
        this.registerFunction(LogErrorFunction.class);
        this.registerFunction(LogDebugFunction.class);
        this.registerFunction(LogInfoFunction.class);
    }

    public static class LogErrorFunction
    extends AbstractLogFunction {
        public static final String FUNCTION_NAME = "error";
        public static final FunctionMetaData metadata = LogErrorFunction.createMetaData("error");

        LogErrorFunction() {
            super(metadata);
        }
    }

    public static class LogDebugFunction
    extends AbstractLogFunction {
        public static final String FUNCTION_NAME = "debug";
        public static final FunctionMetaData metadata = LogDebugFunction.createMetaData("debug");

        LogDebugFunction() {
            super(metadata);
        }
    }

    public static class LogInfoFunction
    extends AbstractLogFunction {
        public static final String FUNCTION_NAME = "info";
        public static final FunctionMetaData metadata = LogInfoFunction.createMetaData("info");

        LogInfoFunction() {
            super(metadata);
        }
    }

    static abstract class AbstractLogFunction
    extends AbstractFunctionExpression {
        protected static FunctionMetaData createMetaData(String functionName) {
            return new FunctionMetaData(functionName, TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("message", TypeFactory.STRING, "message to log").addOptional("eventOrObject", TypeFactory.createEventType(), TypeFactory.createObjectType(), "object to log").addOptional("encodeAsXmlOrJson", TypeFactory.STRING, "format to log object(xml or json), xml by default").build(), "Logs to " + functionName + " trace specified message and event/object encoded in xml(default) or json.");
        }

        AbstractLogFunction(FunctionMetaData metadata) {
            super(metadata);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String message = null;
            String content = null;
            message = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            if (this.argumentsValues.size() > 1) {
                AbstractSerializer serializer;
                boolean asXml = true;
                if (this.argumentsValues.size() > 2) {
                    try {
                        String contentAs = TypeFactory.STRING.convertValue(((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).value, ((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).type);
                        if (contentAs == null) throw this.argumentException(2, "Value of parameter should be 'xml' or 'json'.");
                        if (!contentAs.equalsIgnoreCase("xml") && !contentAs.equalsIgnoreCase("json")) {
                            throw this.argumentException(2, "Value of parameter should be 'xml' or 'json'.");
                        }
                        asXml = contentAs.equalsIgnoreCase("xml");
                    }
                    catch (ValueConversionException exception) {
                        throw this.argumentException(2, exception.getMessage());
                    }
                }
                Class<AbstractLogFunction> clazz = AbstractLogFunction.class;
                // MONITORENTER : com.streamscape.sef.evtrigger.function.expression.function.LogFunctionsUnit$AbstractLogFunction.class
                if (asXml) {
                    String name = "XMLSerializer$LogFunction";
                    XSerializerFactory factory = context.getFabricContext().getXSerializerFactory();
                    XSerializer xSerializer = factory.lookupSerializer(name);
                    if (xSerializer == null) {
                        xSerializer = factory.createSerializer(name);
                        xSerializer.mapAttribute("SemanticType", "class");
                    }
                    serializer = xSerializer;
                } else {
                    serializer = HTTPUtils.getJsonSerializerForRest(context.getFabricContext()).withPrettyPrint(true);
                }
                // MONITOREXIT : clazz
                try {
                    content = serializer.serialize(((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                    Trace.logError(this, "Serialization of object log failed.(" + this.getMetaData().getFunctionName() + " function).");
                }
            }
            String entity = context.getEventTriggerDefinition() != null ? context.getEventTriggerDefinition().getName() : null;
            StringBuilder buffer = new StringBuilder();
            buffer.append(message);
            if (content != null) {
                buffer.append('\n').append(content);
            }
            message = buffer.toString();
            Logger logger = null;
            boolean loggerRequired = true;
            if (context.getComponent() != null) {
                if (context.getComponent() instanceof FabricManagedComponent) {
                    logger = ((FabricManagedComponent)((Object)context.getComponent())).getLogger();
                } else {
                    loggerRequired = false;
                }
            }
            if (logger instanceof ComponentLogger) {
                if (this.getMetaData().getFunctionName().equals("error")) {
                    ((ComponentLogger)logger).logError(entity, message);
                    return this.makeExpressionResult(null);
                }
                if (this.getMetaData().getFunctionName().equals("debug")) {
                    ((ComponentLogger)logger).logDebug(entity, message);
                    return this.makeExpressionResult(null);
                }
                if (!this.getMetaData().getFunctionName().equals("info")) return this.makeExpressionResult(null);
                ((ComponentLogger)logger).logInfo(entity, message);
                return this.makeExpressionResult(null);
            }
            StringBuilder buffer2 = new StringBuilder();
            if (context.getComponent() != null && loggerRequired) {
                buffer2.append('[');
                buffer2.append(context.getComponent().getType()).append('/').append(context.getComponent().getName());
                buffer2.append("] ");
            }
            if (entity != null) {
                buffer2.append('[');
                buffer2.append(entity);
                buffer2.append("] ");
            }
            buffer2.append(message);
            message = buffer2.toString();
            if (logger == null && loggerRequired) {
                Trace.logError(this, "Unable to get logger from the host component. Writing to Trace...\n" + message);
                return this.makeExpressionResult(null);
            }
            if (this.getMetaData().getFunctionName().equals("error")) {
                this.logMessage(logger, message, Logger::logError, msg -> Trace.logError(LogFunctionsUnit.class, msg));
                return this.makeExpressionResult(null);
            }
            if (this.getMetaData().getFunctionName().equals("info")) {
                this.logMessage(logger, message, Logger::logInfo, msg -> Trace.logInfo(LogFunctionsUnit.class, msg));
                return this.makeExpressionResult(null);
            }
            if (!this.getMetaData().getFunctionName().equals("debug")) return this.makeExpressionResult(null);
            this.logMessage(logger, message, Logger::logDebug, msg -> Trace.logDebug(LogFunctionsUnit.class, msg));
            return this.makeExpressionResult(null);
        }

        private void logMessage(Logger logger, String message, BiConsumer<Logger, String> logWriter, Consumer<String> traceWriter) {
            if (logger != null) {
                logWriter.accept(logger, message);
            } else {
                traceWriter.accept(message);
            }
        }
    }
}

