/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.slex.lang.completion.MethodSuggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import java.util.ArrayList;
import java.util.List;

public class FunctionMetaData {
    private String functionName;
    private Type<?> resultType;
    private Arguments arguments;
    private String description;

    public FunctionMetaData(String functionName, Type<?> resultType, String description) {
        this(functionName, resultType, Arguments.builder().build(), description);
    }

    public FunctionMetaData(String functionName, Type<?> resultType, Arguments arguments, String description) {
        this.functionName = functionName;
        this.resultType = resultType;
        this.arguments = arguments;
        this.description = description;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Type<?> getResultType() {
        return this.resultType;
    }

    public Arguments getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFunctionSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.functionName).append("(");
        for (int i = 0; i < this.arguments.arguments.size(); ++i) {
            Argument argument = this.arguments.arguments.get(i);
            if (argument.isOptional()) {
                builder.append("[");
            }
            if (i > 0) {
                builder.append(", ");
            }
            if (argument.getTypes().length > 1) {
                builder.append("{");
            }
            for (Type<?> type : argument.getTypes()) {
                builder.append(type.getName()).append(" | ");
            }
            builder.setLength(builder.length() - 3);
            if (argument.getTypes().length > 1) {
                builder.append(" }");
            }
            builder.append(" ");
            if (argument.isRepeatable()) {
                builder.append("...");
            }
            builder.append(argument.getName());
            if (!argument.isOptional()) continue;
            builder.append("]");
        }
        builder.append(")");
        builder.append(" : ").append(this.resultType.getName());
        return builder.toString();
    }

    public String getArgumentsDescription() {
        if (this.arguments.arguments.size() == 0) {
            return "None";
        }
        StringBuilder builder = new StringBuilder();
        int argumentsNameMaxLength = 0;
        for (Argument argument : this.arguments.arguments) {
            argumentsNameMaxLength = Math.max(argumentsNameMaxLength, argument.getName().length());
        }
        for (int i = 0; i < this.arguments.arguments.size(); ++i) {
            Argument argument;
            if (i > 0) {
                builder.append("\n");
            }
            argument = this.arguments.arguments.get(i);
            builder.append(argument.getName());
            this.appendSpaces(builder, argumentsNameMaxLength - argument.getName().length());
            builder.append(" - ");
            if (argument.description == null) continue;
            this.appendWithIndent(builder, argument.description, argumentsNameMaxLength + 3, false);
        }
        return builder.toString();
    }

    public String getFullDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("Signature\n");
        this.appendWithIndent(builder, this.getFunctionSignature(), 2, true);
        builder.append("\nDescription\n");
        this.appendWithIndent(builder, this.getDescription(), 2, true);
        builder.append("\nArguments\n");
        this.appendWithIndent(builder, this.getArgumentsDescription(), 2, true);
        return builder.toString();
    }

    public MethodSuggestion buildMethodSuggestion() {
        MethodSuggestion suggestion = new MethodSuggestion(this.getFunctionName(), this.getResultType().getName(), SuggestionGroup.METHOD);
        suggestion.setDescription(this.getDescription());
        if (this.getArguments() != null) {
            for (int i = 0; i < this.getArguments().getArgumentsCount(); ++i) {
                Argument argument = this.getArguments().getArgument(i);
                String[] types = new String[]{};
                if (argument.getTypes() != null) {
                    types = new String[argument.getTypes().length];
                    for (int ii = 0; ii < argument.getTypes().length; ++ii) {
                        types[ii] = argument.getTypes()[ii].getName();
                    }
                }
                MethodSuggestion.MethodArgument arg = new MethodSuggestion.MethodArgument(argument.getName(), types);
                arg.setDescription(argument.getDescription());
                arg.setOptional(argument.isOptional());
                arg.setRepeatable(argument.isRepeatable());
                suggestion.addArgument(arg);
            }
        }
        return suggestion;
    }

    private void appendWithIndent(StringBuilder builder, String str, int indent, boolean startFromFirstLine) {
        if (str.length() == 0) {
            return;
        }
        int newLineIndex = 0;
        int offset = 0;
        while ((newLineIndex = str.indexOf("\n", offset)) != -1) {
            if (offset == 0 && startFromFirstLine || offset > 0) {
                this.appendSpaces(builder, indent);
            }
            builder.append(str.substring(offset, newLineIndex));
            builder.append("\n");
            offset = newLineIndex + 1;
        }
        if (offset > 0 || offset == 0 && startFromFirstLine) {
            this.appendSpaces(builder, indent);
        }
        builder.append(str.substring(offset));
    }

    private void appendSpaces(StringBuilder builder, int count) {
        while (count-- > 0) {
            builder.append(" ");
        }
    }

    public static class Arguments {
        public static int MAX_ARGUMENTS_COUNT = Integer.MAX_VALUE;
        private List<Argument> arguments = new ArrayList<Argument>();

        private Arguments() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Argument getArgument(int index) {
            if (index < 0 || index >= this.getMaxArgumentsCount()) {
                return null;
            }
            if (index < this.arguments.size()) {
                return this.arguments.get(index);
            }
            if (this.arguments.get(this.arguments.size() - 1).isRepeatable()) {
                return (Argument)this.arguments.get(this.arguments.size() - 1).clone();
            }
            return null;
        }

        public int getMinArgumentsCount() {
            int count;
            for (count = this.arguments.size(); count > 0 && this.arguments.get(count - 1).isOptional(); --count) {
            }
            return count;
        }

        public int getMaxArgumentsCount() {
            if (this.arguments.size() > 0 && this.arguments.get((int)(this.arguments.size() - 1)).isRepeatable) {
                return MAX_ARGUMENTS_COUNT;
            }
            return this.arguments.size();
        }

        public int getArgumentsCount() {
            return this.arguments.size();
        }

        public static class Builder {
            private Arguments arguments = new Arguments();

            private Builder() {
            }

            public Builder add(String name, Type<?> type, String description) {
                return this.add(name, false, false, description, type);
            }

            public Builder add(String name, Type<?> type1, Type<?> type2, String description) {
                return this.add(name, false, false, description, type1, type2);
            }

            public Builder addOptional(String name, Type<?> type, String description) {
                return this.add(name, true, false, description, type);
            }

            public Builder addOptional(String name, Type<?> type1, Type<?> type2, String description) {
                return this.add(name, true, false, description, type1, type2);
            }

            public Builder addOptionalRepeatable(String name, Type<?> type, String description) {
                return this.add(name, true, true, description, type);
            }

            private Builder add(String name, boolean isOptional, boolean isRepeatable, String descripton, Type<?> ... types) {
                Argument argument = new Argument(name, types);
                argument.isOptional = isOptional;
                argument.isRepeatable = isRepeatable;
                argument.description = descripton;
                if (this.arguments.arguments.size() > 0 && this.arguments.arguments.get(this.arguments.arguments.size() - 1).isRepeatable()) {
                    throw new RuntimeException("Failed to add argument '" + name + "' after repeatable argument '" + this.arguments.arguments.get(this.arguments.arguments.size() - 1).getName() + "'.");
                }
                if (!isOptional) {
                    for (Argument a : this.arguments.arguments) {
                        if (!a.isOptional()) continue;
                        throw new RuntimeException("Failed to add not optional argument '" + name + "' after optional argument '" + a.getName() + "'.");
                    }
                }
                this.arguments.arguments.add(argument);
                return this;
            }

            public Arguments build() {
                return this.arguments;
            }
        }
    }

    public static class Argument
    extends CloneableDataObject {
        private String name;
        private boolean isOptional = false;
        private boolean isRepeatable = false;
        private Type<?>[] types;
        private String description;

        private Argument(String name, Type<?>[] types) {
            this.name = name;
            this.types = types;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public String getDescription() {
            return this.description;
        }

        public Type<?>[] getTypes() {
            return this.types;
        }

        @Override
        public Object clone() {
            Argument result = (Argument)super.clone();
            Type[] typesClone = (Type[])this.types.clone();
            for (int i = 0; i < typesClone.length; ++i) {
                if (typesClone[i] == null) continue;
                typesClone[i] = (Type)typesClone[i].clone();
            }
            result.types = typesClone;
            return result;
        }
    }
}

