/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.info.HelpRegistry;
import com.streamscape.lib.utils.ZipUtils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.evtrigger.file.CopyFileActionStrategy;
import com.streamscape.sef.evtrigger.file.DeleteFileActionStrategy;
import com.streamscape.sef.evtrigger.file.FileActionStrategy;
import com.streamscape.sef.evtrigger.file.MoveFileActionStrategy;
import com.streamscape.sef.evtrigger.file.RenameFileActionStrategy;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class FileFunctionsUnit
extends AbstractFunctionsUnit {
    private static final String tempDir = System.getProperty("EVFSDaemon.txlog.dir", ".txlog");

    FileFunctionsUnit() {
        super(FunctionsUnitType.FILE);
        this.registerFunction(CopyFunction.class);
        this.registerFunction(MoveFunction.class);
        this.registerFunction(RenameFunction.class);
        this.registerFunction(DeleteFunction.class);
        this.registerFunction(ZipFunction.class);
        this.registerFunction(UnzipFunction.class);
        this.registerFunction(SizeFunction.class);
        this.registerFunction(LineCountFunction.class);
        this.registerFunction(ExistsFunction.class);
    }

    public static class CopyFunction
    extends AbstractFileFunction {
        public static final FunctionMetaData metadata = CopyFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("copy", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, TypeFactory.createEventType("FileEvent", FileEvent.class), "source file path or FileEvent").add("targetPath", TypeFactory.STRING, "target file dir path").build(), "Copies file 'sourceFile' to 'targetPath'.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        public CopyFunction() {
            super(metadata);
        }

        @Override
        protected FileActionStrategy createStrategy() {
            return new CopyFileActionStrategy((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value, tempDir, false);
        }
    }

    public static class MoveFunction
    extends AbstractFileFunction {
        public static final FunctionMetaData metadata = MoveFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("move", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, TypeFactory.createEventType("FileEvent", FileEvent.class), "source file path or FileEvent").add("targetPath", TypeFactory.STRING, "target file dir path").build(), "Moves file 'sourceFile' to 'targetPath'.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        public MoveFunction() {
            super(metadata);
        }

        @Override
        protected FileActionStrategy createStrategy() {
            return new MoveFileActionStrategy((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value, tempDir, false);
        }
    }

    public static class RenameFunction
    extends AbstractFileFunction {
        public static final FunctionMetaData metadata = RenameFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("rename", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, TypeFactory.createEventType("FileEvent", FileEvent.class), "source file path or FileEvent").add("targetPath", TypeFactory.STRING, "target file path").build(), "Rename file 'sourceFile' to 'targetPath'.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        public RenameFunction() {
            super(metadata);
        }

        @Override
        protected FileActionStrategy createStrategy() {
            return new RenameFileActionStrategy((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value, tempDir, false);
        }
    }

    public static class DeleteFunction
    extends AbstractFileFunction {
        public static final FunctionMetaData metadata = DeleteFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("delete", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, TypeFactory.createEventType("FileEvent", FileEvent.class), "source file path or FileEvent").build(), "Removes file 'sourceFile'.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        public DeleteFunction() {
            super(metadata);
        }

        @Override
        protected FileActionStrategy createStrategy() {
            return new DeleteFileActionStrategy(tempDir, false);
        }
    }

    public static class ZipFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = ZipFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("zip", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, "source file path").add("resultZipFile", TypeFactory.STRING, "result zip file path").build(), "Compresses file 'sourceFile' and creates ZIP archive 'resultZipFile'.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        public ZipFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            try {
                if (!(((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value instanceof String) || !(((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value instanceof String)) {
                    throw new ExpressionExecutionException("Invalid parameters are passed to 'zip' function. File paths are expected.", this);
                }
                String sourceFile = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
                String targetFile = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
                ZipUtils.compress(new File(sourceFile), new File(targetFile));
            }
            catch (IOException exception) {
                throw new ExpressionExecutionException("Failed to evaluate function. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }
    }

    public static class UnzipFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = UnzipFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("unzip", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, "source ZIP file path").add("resultPath", TypeFactory.STRING, "result path").build(), "Uncompresses file 'sourceFile' and extracts it to 'resultPath'.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        public UnzipFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            try {
                if (!(((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value instanceof String) || !(((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value instanceof String)) {
                    throw new ExpressionExecutionException("Invalid parameters are passed to 'unzip' function. File paths are expected.", this);
                }
                String sourceFile = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
                String targetFile = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
                ZipUtils.extract(new File(sourceFile), new File(targetFile));
            }
            catch (IOException exception) {
                throw new ExpressionExecutionException("Failed to evaluate function. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }
    }

    public static class SizeFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = SizeFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("size", TypeFactory.LONG, FunctionMetaData.Arguments.builder().add("filePath", TypeFactory.STRING, TypeFactory.createEventType("FileEvent", FileEvent.class), "source file path or FileEvent").build(), "Gets file size.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        public SizeFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            File file;
            this.checkArgumentNotNull(0);
            if (((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value instanceof String) {
                String filePath = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
                file = new File(filePath);
                if (!file.exists()) {
                    throw new DataspaceException("File '" + filePath + "' doesn't exist.");
                }
            } else {
                throw new ExpressionExecutionException("Invalid parameter is passed to 'size' function. File path is expected.", this);
            }
            return this.makeExpressionResult(FileUtils.sizeOf(file));
        }
    }

    public static class LineCountFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = LineCountFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("lineCount", TypeFactory.LONG, FunctionMetaData.Arguments.builder().add("filePath", TypeFactory.STRING, TypeFactory.createEventType("FileEvent", FileEvent.class), "source file path or FileEvent").addOptional("charset", TypeFactory.STRING, "charset").addOptional("lineCountToAnalyze", TypeFactory.STRING, "line count to analyze for approximate line count").build(), "Gets count of lines for file.\nIf lineCountToAnalyze parameter is specified then approximate line count will be returned based on first lineCountToAnalyze line count.\n\n" + HelpRegistry.dropboxHelp("File path "));
        }

        public LineCountFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            Path path;
            this.checkArgumentNotNull(0);
            if (((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value instanceof String) {
                String filePath = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
                path = Paths.get(filePath, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new DataspaceException("File '" + filePath + "' doesn't exist.");
                }
            } else {
                throw new ExpressionExecutionException("Invalid parameter is passed to 'size' function. File path is expected.", this);
            }
            Charset charset = StandardCharsets.UTF_8;
            if (this.argumentsValues.size() >= 2 && ((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value instanceof String) {
                charset = Charset.forName((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value);
            }
            int lineCountToAnalyze = 0;
            if (this.argumentsValues.size() >= 3 && ((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).value instanceof Number) {
                lineCountToAnalyze = ((Number)((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).value).intValue();
            }
            try {
                return this.makeExpressionResult(com.streamscape.tools.lexer.FileUtils.getFileCharactersInfo(path.toFile(), charset, lineCountToAnalyze).getLinesCount());
            }
            catch (IOException ioEx) {
                throw new ExpressionExecutionException("IO error: " + ioEx.getMessage());
            }
        }
    }

    public static class ExistsFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = ExistsFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("exists", TypeFactory.BOOLEAN, FunctionMetaData.Arguments.builder().add("filePath", TypeFactory.STRING, TypeFactory.createEventType("FileEvent", FileEvent.class), "source file path or FileEvent").build(), "Checks whether a file exists or not.");
        }

        public ExistsFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            if (((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value instanceof String) {
                String filePath = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
                File file = new File(filePath);
                return this.makeExpressionResult(file.exists());
            }
            throw new ExpressionExecutionException("Invalid parameter is passed to 'exists' function. File path is expected.", this);
        }
    }

    static abstract class AbstractFileFunction
    extends AbstractFunctionExpression {
        protected AbstractFileFunction(FunctionMetaData metadata) {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            if (this.argumentsValues.size() > 1) {
                this.checkArgumentNotNull(1);
            }
            try {
                FileActionStrategy trigger = this.createStrategy();
                trigger.setDatagramFactory(context.getEventDatagramFactory());
                if (((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value instanceof String) {
                    trigger.setSourceFilePath((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value);
                    trigger.invokeAction(null);
                } else {
                    trigger.invokeAction((ImmutableEventDatagram)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value);
                }
                if (!trigger.isSuccessed()) {
                    throw new ExpressionExecutionException("File transaction failed. See trace log for details.", this);
                }
            }
            catch (FabricEventException exception) {
                throw new ExpressionExecutionException("Failed to evaluate function. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }

        protected abstract FileActionStrategy createStrategy();
    }
}

