/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.Trace;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import java.sql.SQLException;

public class ExecResult {
    public static int DIRECTORY_DOESNOT_EXISTS = -2;
    public static int EXEC_FAIELD = -3;
    public static int EXECUTION_EXCEPTION = -4;
    public static int EXECUTION_INTERRUPTED = -5;
    private int code;
    private String output;
    private String error;

    private ExecResult() {
    }

    public int getCode() {
        return this.code;
    }

    public String getOutput() {
        return this.output;
    }

    public String getError() {
        return this.error;
    }

    public RowSet getOutputRowSet() {
        RowMetaData meta = new RowMetaData();
        meta.addColumn("Output", String.class);
        RowSet rowSet = new RowSet(meta);
        if (this.output != null) {
            int posBegin = 0;
            int posEnd = 0;
            while (posBegin < this.output.length() && (posEnd = this.output.indexOf(10, posBegin)) != -1 || posBegin < this.output.length() || posBegin == 0 && this.output.length() == 0) {
                try {
                    if (posEnd == -1) {
                        posEnd = this.output.length();
                    }
                    rowSet.addToRowSet(new Object[]{this.output.substring(posBegin, posEnd)});
                    posBegin = posEnd + 1;
                }
                catch (SQLException exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
        return rowSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ExecResult homeDirectoryDoesntExist(String directory) {
        return ExecResult.builder().setCode(DIRECTORY_DOESNOT_EXISTS).setError("Home directory '" + directory + "' doesn't exist.").build();
    }

    public static ExecResult execCallFailed(Exception exception) {
        return ExecResult.builder().setCode(EXEC_FAIELD).setError("Exec call failed: " + exception.getMessage()).build();
    }

    public static class Builder {
        private ExecResult execResult = new ExecResult();

        private Builder() {
        }

        public Builder setCode(int code) {
            this.execResult.code = code;
            return this;
        }

        public Builder setOutput(String output) {
            this.execResult.output = output;
            return this;
        }

        public Builder setError(String error) {
            this.execResult.error = error;
            return this;
        }

        public ExecResult build() {
            return this.execResult;
        }
    }
}

