/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.mapper.ConverterPlugin;
import com.streamscape.omf.mapper.ConverterPluginDescriptor;
import com.streamscape.omf.mapper.mf.ConverterPluginManager;
import com.streamscape.omf.mapper.mf.ConverterPluginManagerException;
import com.streamscape.repository.types.Prototype;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.ExceptionEvent;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ConstantExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.io.File;
import java.util.Arrays;

public class EventFunctionsUnit
extends AbstractFunctionsUnit {
    EventFunctionsUnit() {
        super(FunctionsUnitType.EVENTS);
        this.registerFunction(CreateAckFunction.class);
        this.registerFunction(CreateAckForEventIdFunction.class);
        this.registerFunction(CreateAuditEventFunction.class);
        this.registerFunction(CreateMailEventFunction.class);
        this.registerFunction(CreateFileEventFunction.class);
        this.registerFunction(CreateFileContentFunction.class);
        this.registerFunction(CreateExceptionEventFunction.class);
        this.registerFunction(CopyEIMFunction.class);
        this.registerFunction(ConvertFunction.class);
    }

    private static void copyEIM(ImmutableEventDatagram from, ImmutableEventDatagram to) {
        String eventKey = null;
        String eventGroupId = null;
        byte[] correlationIdAsBytes = null;
        if (from instanceof EventDatagram) {
            correlationIdAsBytes = ((EventDatagram)from).getCorrelationIdAsBytes();
            eventGroupId = ((EventDatagram)from).getEventGroupId();
            eventKey = ((EventDatagram)from).getEventKey();
        } else if (from instanceof ExceptionEventDatagram) {
            correlationIdAsBytes = ((ExceptionEventDatagram)from).getCorrelationIdAsBytes();
            eventGroupId = ((ExceptionEventDatagram)from).getEventGroupId();
            eventKey = ((ExceptionEventDatagram)from).getEventKey();
        } else if (from instanceof AdvisoryEventDatagram) {
            correlationIdAsBytes = ((AdvisoryEventDatagram)from).getCorrelationIdAsBytes();
            eventGroupId = ((AdvisoryEventDatagram)from).getEventGroupId();
            eventKey = ((AdvisoryEventDatagram)from).getEventKey();
        } else if (from instanceof OpaqueDatagram) {
            eventGroupId = ((OpaqueDatagram)from).getEventGroupId();
            eventKey = ((OpaqueDatagram)from).getEventKey();
        }
        if (to instanceof EventDatagram) {
            ((EventDatagram)to).setCorrelationIdAsBytes(correlationIdAsBytes);
            ((EventDatagram)to).setEventGroupId(eventGroupId);
            ((EventDatagram)to).setEventKey(eventKey);
        } else if (to instanceof ExceptionEventDatagram) {
            ((ExceptionEventDatagram)to).setCorrelationIdAsBytes(correlationIdAsBytes);
            ((ExceptionEventDatagram)to).setEventGroupId(eventGroupId);
            ((ExceptionEventDatagram)to).setEventKey(eventKey);
        } else if (to instanceof AdvisoryEventDatagram) {
            ((AdvisoryEventDatagram)to).setCorrelationIdAsBytes(correlationIdAsBytes);
            ((AdvisoryEventDatagram)to).setEventGroupId(eventGroupId);
            ((AdvisoryEventDatagram)to).setEventKey(eventKey);
        } else if (to instanceof OpaqueDatagram) {
            ((OpaqueDatagram)to).setEventGroupId(eventGroupId);
            ((OpaqueDatagram)to).setEventKey(eventKey);
        }
    }

    public static class CreateAckFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = CreateAckFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createAck", TypeFactory.createEventType("AcknowledgementEvent", AcknowledgementEvent.class), FunctionMetaData.Arguments.builder().add("event", TypeFactory.createEventType(), "event for which AcknowledgementEvent is created").add("withSourceData", TypeFactory.BOOLEAN, "if true data from source event are set to result AcknowledgementEvent").addOptional("onAcknowledgeAction", TypeFactory.createEnumType("AcknowledgeAction", AcknowledgeAction.class.getName()), "acknowledge action, default action is AcknowledgeAction.ACKNOWLEDGE\nthe following actions are allowed:\n  AcknowledgeAction.ACKNOWLEDGE             - Acknowledges an event datagram but takes no further action.\n  AcknowledgeAction.ACKNOWLEDGE_AND_FORWARD - Acknowledges the event datagram and forwards it to its next destination specified by ForwardTo.\n  AcknowledgeAction.ACKNOWLEDGE_AND_DISCARD - Acknowledges the event datagram and discards it.\n                                              If an event datagram is queued up it is removed from the queue. This is how a standard message queue functions.\n  AcknowledgeAction.ACKNOWLEDGE_AND_EXPIRE  - Acknowledges the event datagram and specifies that this datagram should be expired by the processor.\n  AcknowledgeAction.ACKNOWLEDGE_UNDELIVERED - Acknowledges the event datagram as not delivered to its destination.\n  AcknowledgeAction.ACKNOWLEDGE_AND_SUSPEND - Acknowledges the event datagram and instructs the recipient that all further processing of this eventId should be suspended.").build(), "Creates and returns an instance of an AcknowledgementEvent datagram based on the supplied Source Event Datagram and action.\nIt is expected that Event Identity Management elements from the header are copied into the acknowledgement to allow correlation between an event and it's acknowledgement.\nIf withSourceData flag is true data from source event are set to AcknowledgeEvent.");
        }

        public CreateAckFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            if (!(((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value instanceof ImmutableEventDatagram)) {
                throw this.argumentException(0, "Should be of type event.");
            }
            ImmutableEventDatagram event = (ImmutableEventDatagram)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            boolean withSourceData = (Boolean)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            try {
                AcknowledgementEvent ackEvent = context.createAcknowledgement(event, withSourceData);
                if (this.argumentsValues.size() > 2) {
                    ackEvent.setAction((AcknowledgeAction)((Object)((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).value));
                }
                return this.makeExpressionResult(ackEvent);
            }
            catch (ValueConversionException exception) {
                throw this.argumentException(1, exception.getMessage());
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Creating Acknowledgement Event failed.", this, exception);
            }
        }

        @Override
        protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
            AbstractExpression compiled = super.onCompile(context);
            EventType eventType = (EventType)((AbstractExpression)this.arguments.get(0)).getResultType();
            if (eventType.getEventId() == null || eventType.getEventId().length() == 0) {
                throw this.argumentException(0, "EventId not defined.");
            }
            this.setResultType(TypeFactory.createEventType(this.createReplyEventId(eventType.getEventId())));
            this.getParentBlock().getStatementContext().addUsedEventId(eventType.getEventId());
            return compiled;
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            EventType eventType = (EventType)((AbstractExpression)this.arguments.get(0)).getResultType();
            if (eventType.getEventId() == null || eventType.getEventId().length() == 0) {
                throw this.argumentException(0, "EventId not defined.");
            }
            this.setResultType(TypeFactory.createEventType("AcknowledgementEvent", AcknowledgementEvent.class, this.createReplyEventId(eventType.getEventId())));
        }

        private String createReplyEventId(String eventId) {
            return eventId.startsWith("e.reply.") ? eventId : "e.reply." + eventId;
        }
    }

    public static class CreateAckForEventIdFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = CreateAckForEventIdFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createAckForEventId", TypeFactory.createEventType("AcknowledgementEvent", AcknowledgementEvent.class), FunctionMetaData.Arguments.builder().add("eventId", TypeFactory.STRING, "event id of a result event.").build(), "Creates an instance of AcknowledgementEvent using the specified event id.");
        }

        public CreateAckForEventIdFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            try {
                String eventId = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
                AcknowledgementEvent ackEvent = context.createAcknowledgement(eventId);
                return this.makeExpressionResult(ackEvent);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Creating Acknowledgement Event failed.", this, exception);
            }
        }

        @Override
        protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
            AbstractExpression compiled = super.onCompile(context);
            String eventId = (String)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
            this.setResultType(TypeFactory.createEventType(eventId));
            this.getParentBlock().getStatementContext().addUsedEventId(eventId);
            return compiled;
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            if (!(this.arguments.get(0) instanceof ConstantExpression)) {
                throw this.argumentException(0, "Only constant string allowed for the eventId.");
            }
            String eventId = (String)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
            if (eventId == null) {
                throw this.argumentException(0, "Null value not allowed for the eventId.");
            }
            this.setResultType(TypeFactory.createEventType("AcknowledgementEvent", AcknowledgementEvent.class, eventId));
        }
    }

    public static class CreateAuditEventFunction
    extends AbstractCreateEventFunction<AuditEvent> {
        public static final FunctionMetaData metadata = CreateAuditEventFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createAuditEvent", TypeFactory.createEventType(), FunctionMetaData.Arguments.builder().add("auditEventId", TypeFactory.STRING, "result AuditEvent id can be set to real eventId or to 'default', 'sql', 'process' or 'user' that cast to event.audit.{default|sql|process|user} event ids").add("auditMessage", TypeFactory.STRING, "audit message that set to the result AuditEvent").add("severity", TypeFactory.createEnumType("Severity", Severity.class.getName()), "severity that set to the result AuditEvent, possible values: Severity.SERVE, Severity.WARNING, Severity.INFO, Severity.GENERIC").addOptional("baseEvent", TypeFactory.createEventType(), "if set EIM info copied to the result AuditEvent").build(), "Creates and returns an instance of an audit event datagram based on specified auditEventId, auditMessage and severity.\nIf baseEvent is specified then Event Identity Management elements from the header are copied into the result auditEvent.");
        }

        public CreateAuditEventFunction() {
            super(metadata, AuditEvent.class);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            this.checkArgumentNotNull(2);
            String auditMessage = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            Severity severity = (Severity)((Object)((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).value);
            AuditEvent auditEvent = (AuditEvent)this.createEvent(context);
            try {
                auditEvent.setAuditData(auditMessage);
                auditEvent.setSeverity(severity);
            }
            catch (SecurityViolationException exception) {
                throw new ExpressionExecutionException("Failed to set audit event [" + this.getEventId() + "] properties. Cause: " + exception.getMessage(), this, exception);
            }
            if (this.argumentsValues.size() > 3) {
                EventFunctionsUnit.copyEIM((ImmutableEventDatagram)((Expression.ValueTypeResult)this.argumentsValues.get((int)3)).value, auditEvent);
            }
            return this.makeExpressionResult(auditEvent);
        }

        @Override
        protected String transformEventId(String eventId) {
            if (eventId.equals("default")) {
                return "event.audit";
            }
            if (eventId.equals("sql")) {
                return "event.audit.sql";
            }
            if (eventId.equals("process")) {
                return "event.audit.process";
            }
            if (eventId.equals("user")) {
                return "event.audit.user";
            }
            return eventId;
        }
    }

    public static class CreateMailEventFunction
    extends AbstractCreateEventFunction<MailEvent> {
        public static final FunctionMetaData metadata = CreateMailEventFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createMailEvent", TypeFactory.createEventType(), FunctionMetaData.Arguments.builder().add("mailEventId", TypeFactory.STRING, "result MailEvent id, should be constant string").add("subject", TypeFactory.STRING, "mail subject").add("body", TypeFactory.STRING, "mail body").add("contentType", TypeFactory.STRING, "mail content type, if null then 'text/html' type is used").add("toRecipients", TypeFactory.STRING, "list of comma separated recipient mail addresses").addOptional("ccRecipients", TypeFactory.STRING, "list of comma separated cc mail addresses").addOptional("baseEvent", TypeFactory.createEventType(), "if set EIM info copied to the result MailEvent").build(), "Creates and returns an instance of a mail event datagram based on specified arguments.\nIf baseEvent is specified then Event Identity Management elements from the header are copied into the result mailEvent.");
        }

        public CreateMailEventFunction() {
            super(metadata, MailEvent.class);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String ccRecipients;
            String subject = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            String body = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).value;
            String contentType = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)3)).value;
            String toRecipients = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)4)).value;
            String string = ccRecipients = this.argumentsValues.size() > 5 ? (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)5)).value : null;
            if (contentType == null) {
                contentType = "text/html";
            }
            if (toRecipients == null || toRecipients.length() == 0) {
                throw this.argumentException(4, "Recipients should be set.");
            }
            MailEvent mailEvent = (MailEvent)super.createEvent(context);
            try {
                mailEvent.setSubject(subject);
                mailEvent.setBody(body);
                mailEvent.setContentType(contentType);
                mailEvent.setTo(Arrays.asList(toRecipients.split(",")));
                if (ccRecipients != null && ccRecipients.length() > 0) {
                    mailEvent.setCc(Arrays.asList(ccRecipients.split(",")));
                }
            }
            catch (SecurityViolationException exception) {
                throw new ExpressionExecutionException("Failed to set mail event [" + this.getEventId() + "] properties. Cause: " + exception.getMessage(), this, exception);
            }
            if (this.argumentsValues.size() > 6) {
                EventFunctionsUnit.copyEIM((ImmutableEventDatagram)((Expression.ValueTypeResult)this.argumentsValues.get((int)6)).value, mailEvent);
            }
            return this.makeExpressionResult(mailEvent);
        }
    }

    public static class CreateFileEventFunction
    extends AbstractCreateEventFunction<FileEvent> {
        public static final FunctionMetaData metadata = CreateFileEventFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createFileEvent", TypeFactory.createEventType(), FunctionMetaData.Arguments.builder().add("fileEventId", TypeFactory.STRING, "result FileEvent id, should be constant string").add("filepath", TypeFactory.STRING, "file path").build(), "Creates and returns an instance of file event datagram based on specified filepath.");
        }

        public CreateFileEventFunction() {
            super(metadata, FileEvent.class);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            String filepath = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            FileEvent fileEvent = (FileEvent)this.createEvent(context);
            try {
                fileEvent.init(new File(filepath), FileState.STATIC);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Failed to init file event [" + this.getEventId() + "]. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(fileEvent);
        }
    }

    public static class CreateFileContentFunction
    extends AbstractCreateEventFunction<BytesEvent> {
        public static final FunctionMetaData metadata = CreateFileContentFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createFileContent", TypeFactory.createEventType(BytesEvent.class.getSimpleName(), BytesEvent.class), FunctionMetaData.Arguments.builder().add("bytesEventId", TypeFactory.STRING, "result BytesEvent id, should be constant string").add("filepathOrFileEvent", TypeFactory.STRING, TypeFactory.createEventType(FileEvent.class.getSimpleName(), FileEvent.class), "filepath or FileEvent").build(), "Creates and returns an instance of an BytesEvent initialized with provided file data.\nIf second argument is FileEvent EIM information is copied to BytesEvent.");
        }

        public CreateFileContentFunction() {
            super(metadata, BytesEvent.class);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String filepath;
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            FileEvent fileEvent = null;
            if (((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value instanceof FileEvent) {
                fileEvent = (FileEvent)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
                try {
                    filepath = fileEvent.getAbsoluteFileName();
                }
                catch (SecurityViolationException exception) {
                    throw this.argumentException(1, "Failed to extract filename. Cause: " + exception.getMessage());
                }
            } else if (((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value instanceof String) {
                filepath = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            } else {
                throw this.argumentException(1, "Wrong type of arguments, should be String or FileEvent, but passed '" + ((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).type.getName() + "'.");
            }
            BytesEvent bytesEvent = (BytesEvent)this.createEvent(context);
            try {
                bytesEvent.setBytes(FileIOUtils.getFileContent(new File(filepath)));
                if (fileEvent != null) {
                    EventFunctionsUnit.copyEIM(fileEvent, bytesEvent);
                }
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Failed to init bytes event [" + this.getEventId() + "]. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(bytesEvent);
        }
    }

    public static class CreateExceptionEventFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = CreateExceptionEventFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createExceptionEvent", TypeFactory.createEventType(ExceptionEvent.class.getSimpleName(), ExceptionEvent.class, "event.exception"), FunctionMetaData.Arguments.builder().add("errorMessage", TypeFactory.STRING, "error message").addOptional("errorCode", TypeFactory.INT, "error code").addOptional("severity", TypeFactory.createEnumType("Severity", Severity.class.getName()), "severity, possible values: Severity.SERVE, Severity.WARNING, Severity.INFO, Severity.GENERIC").addOptional("baseEvent", TypeFactory.createEventType(), "base event, if specified EIM copies to result event").build(), "Creates and returns an instance of an ExceptionEvent initialized with specified message, code and severity.\nIf baseEvent is specified then Event Identity Management elements from the header are copied into the result exception event.");
        }

        public CreateExceptionEventFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            ExceptionEvent exceptionEvent;
            try {
                exceptionEvent = (ExceptionEvent)context.createEvent("event.exception");
            }
            catch (DatagramFactoryException exception) {
                throw new ExpressionExecutionException("Failed to create event [event.exception] instance. Cause: " + exception.getMessage(), this, exception);
            }
            if (exceptionEvent == null) {
                throw new ExpressionExecutionException("Failed to create event [event.exception] instance.", this);
            }
            exceptionEvent.setErrorMessage((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value);
            if (this.argumentsValues.size() > 1) {
                exceptionEvent.setErrorCode((Integer)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value);
            }
            if (this.argumentsValues.size() > 2) {
                exceptionEvent.setSeverity((Severity)((Object)((Expression.ValueTypeResult)this.argumentsValues.get((int)2)).value));
            }
            if (this.argumentsValues.size() > 3 && ((Expression.ValueTypeResult)this.argumentsValues.get((int)3)).value != null) {
                EventFunctionsUnit.copyEIM((ImmutableEventDatagram)((Expression.ValueTypeResult)this.argumentsValues.get((int)3)).value, exceptionEvent);
            }
            return this.makeExpressionResult(exceptionEvent);
        }

        @Override
        protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
            AbstractExpression compiled = super.onCompile(context);
            this.getParentBlock().getStatementContext().addUsedEventId("event.exception");
            return compiled;
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            Prototype prototype = context.lookupEventPrototype("event.exception");
            if (prototype == null) {
                throw new ExpressionExecutionException("Exception prototype [event.exception] does not exist.", this);
            }
            if (!prototype.getModelName().equals(ExceptionEvent.class.getSimpleName())) {
                throw new ExpressionExecutionException("Event [event.exception] should be '" + ExceptionEvent.class.getSimpleName() + "', but passed " + prototype.getModelName() + ".", this);
            }
        }
    }

    public static class CopyEIMFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = CopyEIMFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("copyEIM", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceEvent", TypeFactory.createEventType(), "source event").add("tragetEvent", TypeFactory.createEventType(), "target event").build(), "Copies Event Identity Management elements(correlationId, eventKey and eventGroupId) from sourceEvent to targetEvent.");
        }

        public CopyEIMFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            ImmutableEventDatagram fromEvent = (ImmutableEventDatagram)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            ImmutableEventDatagram toEvent = (ImmutableEventDatagram)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value;
            EventFunctionsUnit.copyEIM(fromEvent, toEvent);
            return this.makeExpressionResult(null);
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }
    }

    public static class ConvertFunction
    extends AbstractFunctionExpression {
        public static final FunctionMetaData metadata = ConvertFunction.createMetaData();
        private ConverterPlugin converterPlugin;

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("convert", TypeFactory.createObjectType(), FunctionMetaData.Arguments.builder().add("converterName", TypeFactory.STRING, "name of converter plugin, should be constant string").add("object", TypeFactory.createObjectType(), "object to convert").build(), "Executes converter plugin with specified 'converterName' and specified 'object'.\nReturns converted object. Converter name should be constant.");
        }

        public ConvertFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                return this.makeExpressionResult(this.converterPlugin.convert(((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value));
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Conversion failed: " + exception.getMessage(), this, exception);
            }
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            if (!(this.arguments.get(0) instanceof ConstantExpression)) {
                throw this.argumentException(0, "Only constant string allowed for the converterName.");
            }
            String converterName = (String)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
            if (converterName == null) {
                throw new ExpressionExecutionException("Converter name should be not null.", this);
            }
            ConverterPluginManager converterPluginManager = context.getConverterPluginManager();
            if (converterPluginManager == null) {
                throw new ExpressionExecutionException("Converter plugin manager is not avaiable.", this);
            }
            if (!converterPluginManager.existsConverterPlugin(converterName)) {
                throw new ExpressionExecutionException("Converter plugin '" + converterName + "' doesn't exist.", this);
            }
            ConverterPluginDescriptor converterPluginDescriptor = converterPluginManager.getConverterPluginDescriptor(converterName);
            Type<?> inType = null;
            try {
                inType = TypeFactory.createType(converterPluginDescriptor.getInboundSemanticType(), context);
                if (inType == null) {
                    throw new ClassNotFoundException();
                }
                inType.canConvert(((AbstractExpression)this.arguments.get(1)).getResultType());
            }
            catch (ClassNotFoundException exception) {
                throw new ExpressionExecutionException("Failed to initialize inbound semantic type '" + converterPluginDescriptor.getOutboundSemanticType() + "'.", this, exception);
            }
            catch (TypeConversionException exception) {
                throw this.argumentException(1, "Failed to convert object of type '" + ((AbstractExpression)this.arguments.get(1)).getResultType().getName() + "' to '" + inType.getName() + "'.");
            }
            try {
                this.setResultType(TypeFactory.createType(converterPluginDescriptor.getOutboundSemanticType(), context));
            }
            catch (ClassNotFoundException exception) {
                throw new ExpressionExecutionException("Failed to initialize converter outbound semantic type '" + converterPluginDescriptor.getOutboundSemanticType() + "'.", this, exception);
            }
            try {
                this.converterPlugin = converterPluginManager.createConverterPlugin(converterName);
            }
            catch (ConverterPluginManagerException exception) {
                throw new ExpressionExecutionException("Failed to create converter '" + converterName + "'. Cause: " + exception.getMessage(), this, exception);
            }
        }
    }

    static abstract class AbstractCreateEventFunction<T extends ImmutableEventDatagram>
    extends AbstractFunctionExpression {
        private Class<? extends T> eventModelClass;
        private String eventId;

        protected AbstractCreateEventFunction(FunctionMetaData metadata, Class<? extends T> eventModelClass) {
            super(metadata);
            this.eventModelClass = eventModelClass;
        }

        @Override
        protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
            AbstractExpression compiled = super.onCompile(context);
            if (!(this.arguments.get(0) instanceof ConstantExpression)) {
                throw this.argumentException(0, "Only constant string allowed for the eventId.");
            }
            this.eventId = (String)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
            if (this.eventId == null) {
                throw this.argumentException(0, "Null value not allowed for the eventId.");
            }
            this.eventId = this.transformEventId(this.eventId);
            if (!StringUtils.validateEventId(this.eventId)) {
                throw new ExpressionExecutionException("Invalid event id [" + this.eventId + "].", this);
            }
            this.setResultType(TypeFactory.createEventType(this.eventId));
            this.getParentBlock().getStatementContext().addUsedEventId(this.eventId);
            return compiled;
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
            if (!(this.arguments.get(0) instanceof ConstantExpression)) {
                throw this.argumentException(0, "Only constant string allowed for the eventId.");
            }
            this.eventId = (String)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
            if (this.eventId == null) {
                throw this.argumentException(0, "Null value not allowed for the eventId.");
            }
            this.eventId = this.transformEventId(this.eventId);
            Prototype prototype = context.lookupEventPrototype(this.eventId);
            if (prototype == null) {
                throw new ExpressionExecutionException("Event prototype [" + this.eventId + "] does not exist.", this);
            }
            if (!prototype.getModelName().equals(this.eventModelClass.getSimpleName())) {
                throw new ExpressionExecutionException("Event [" + this.eventId + "] model should be '" + this.eventModelClass.getSimpleName() + "', but it is '" + prototype.getModelName() + "'.", this);
            }
            try {
                this.setResultType(TypeFactory.createEventType(context, this.eventId));
            }
            catch (Exception exception) {
                throw this.argumentException(0, "Failed to create event [" + this.eventId + "].");
            }
        }

        protected T createEvent(TriggerFunctionContext context) throws ExpressionExecutionException {
            ImmutableEventDatagram event;
            try {
                event = context.createEvent(this.eventId);
            }
            catch (DatagramFactoryException exception) {
                throw new ExpressionExecutionException("Failed to create event [" + this.eventId + "] instance. Cause: " + exception.getMessage(), this, exception);
            }
            if (event == null) {
                throw new ExpressionExecutionException("Failed to create event [" + this.eventId + "] instance.", this);
            }
            return (T)event;
        }

        protected String getEventId() {
            return this.eventId;
        }

        protected Class<? extends T> getEventModelClass() {
            return this.eventModelClass;
        }

        protected String transformEventId(String eventId) {
            return eventId;
        }
    }
}

