/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.omf.json.jackson.JsonDateTimeSerializers;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFunctionsUnit
extends AbstractFunctionsUnit {
    DateFunctionsUnit() {
        super(FunctionsUnitType.DATE);
        this.registerFunction(FromStringFunction.class);
        this.registerFunction(ToStringFunction.class);
    }

    public static class FromStringFunction
    extends AbstractDateFunction {
        public static final FunctionMetaData metadata = FromStringFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("fromString", TypeFactory.DATE, FunctionMetaData.Arguments.builder().add("dateRep", TypeFactory.STRING, "date representation in string format").addOptional("javaPattern", TypeFactory.STRING, "date pattern in java style, if not specified dataspace default sqltimestamp format is used").build(), "Converts string representation of the data into java object using provided pattern.\n\nTimestamp format should be specified using Java date format syntax:\n\n  Letter   Date or Time Component            Presentation         Examples\n  G        Era designator                    Text                 AD\n  y        Year                              Year                 1996; 96\n  Y        Week year                         Year                 2009; 09\n  M        Month in year (context sensitive) Month                July; Jul; 07\n  L        Month in year (standalone form)   Month                July; Jul; 07\n  w        Week in year                      Number               27\n  W        Week in month                     Number               2\n  D        Day in year                       Number               189\n  d        Day in month                      Number               10\n  F        Day of week in month              Number               2\n  E        Day name in week                  Text                 Tuesday; Tue\n  u        Day number of week (1 = Monday, ) Number               1\n  a        Am/pm marker                      Text                 PM\n  H        Hour in day (0-23)                Number               0\n  k        Hour in day (1-24)                Number               24\n  K        Hour in am/pm (0-11)              Number               0\n  h        Hour in am/pm (1-12)              Number               12\n  m        Minute in hour                    Number               30\n  s        Second in minute                  Number               55\n  S        Millisecond                       Number               978\n  z        Time zone                         General time zone    Pacific Standard Time; PST; GMT-08:00\n  Z        Time zone                         RFC 822 time zone    -0800; +0800\n  X        Time zone                         ISO 8601 time zone   -08; +08; Z\n  XX       Time zone                         ISO 8601 time zone   -0800; +0800\n  XXX      Time zone                         ISO 8601 time zone   -08:00; +08:00\n\n\nBy default date and timestamp are serialized in local timezone. To append timezone name/value use z,Z or X placeholders.\nTo serialize date or timestamp in UTC timezone, append 'Z' placeholder to the end: yyyy-MM-dd'T'HH:mm:ss'Z'\n\nThe following date/timestamp formats are also used as default during date/timestamp deserialization:\n   yyyy-MM-dd'T'HH:mm:ss\n   yyyy-MM-dd'T'HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss.SSSX\n   yyyy-MM-dd'T'HH:mm:ssXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXX\n   yyyy-MM-dd'T'HH:mm:ssXXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXXX\n   yyyy-MM-dd'T'HH:mm:ss z\n   yyyy-MM-dd'T'HH:mm:ss.SSS z\n\nDefault Dataspace formats (used in dataspace queries, and displayed in console):\n   yyyy-MM-dd HH:mm:ss - date\n   MM-yyyy-dd - sqldate\n   ss:HH:mm - sqltime\n   MM-yyyy-dd HH:mm:ss.SSS - sqltimestamp\n\nOther formats:\n\n   MM/dd/yy HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss'Z'\n\nDate unit samples:\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSSXXX')\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS z')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSS''Z''')\n\n    date.fromString('2024-03-22T06:44:56.156Z')\n    date.fromString('2024-03-22T06:44:56.156+03')\n    date.fromString('2024-03-22T06:44:56.156 PST')\n\n");
        }

        public FromStringFunction() {
            super(metadata);
        }

        @Override
        protected Object convert(Object source, SimpleDateFormat format) throws ExpressionExecutionException {
            if (!(source instanceof String)) {
                throw new ExpressionExecutionException("Date for parsing should be a string.", this);
            }
            try {
                return new Date(JsonDateTimeSerializers.parseDateOrTimestampToMillis((String)source, format));
            }
            catch (IOException | ParseException ex) {
                throw new ExpressionExecutionException("Unable to parse date '" + String.valueOf(source) + "' using the '" + format.toPattern() + "' pattern.", this);
            }
        }
    }

    public static class ToStringFunction
    extends AbstractDateFunction {
        public static final FunctionMetaData metadata = ToStringFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("toString", TypeFactory.STRING, FunctionMetaData.Arguments.builder().add("dateObj", TypeFactory.DATE, "date object").addOptional("javaPattern", TypeFactory.STRING, "date pattern in java style, if not specified dataspace default sqltimestamp format is used").build(), "Formats date object into string using provided pattern.\n\nTimestamp format should be specified using Java date format syntax:\n\n  Letter   Date or Time Component            Presentation         Examples\n  G        Era designator                    Text                 AD\n  y        Year                              Year                 1996; 96\n  Y        Week year                         Year                 2009; 09\n  M        Month in year (context sensitive) Month                July; Jul; 07\n  L        Month in year (standalone form)   Month                July; Jul; 07\n  w        Week in year                      Number               27\n  W        Week in month                     Number               2\n  D        Day in year                       Number               189\n  d        Day in month                      Number               10\n  F        Day of week in month              Number               2\n  E        Day name in week                  Text                 Tuesday; Tue\n  u        Day number of week (1 = Monday, ) Number               1\n  a        Am/pm marker                      Text                 PM\n  H        Hour in day (0-23)                Number               0\n  k        Hour in day (1-24)                Number               24\n  K        Hour in am/pm (0-11)              Number               0\n  h        Hour in am/pm (1-12)              Number               12\n  m        Minute in hour                    Number               30\n  s        Second in minute                  Number               55\n  S        Millisecond                       Number               978\n  z        Time zone                         General time zone    Pacific Standard Time; PST; GMT-08:00\n  Z        Time zone                         RFC 822 time zone    -0800; +0800\n  X        Time zone                         ISO 8601 time zone   -08; +08; Z\n  XX       Time zone                         ISO 8601 time zone   -0800; +0800\n  XXX      Time zone                         ISO 8601 time zone   -08:00; +08:00\n\n\nBy default date and timestamp are serialized in local timezone. To append timezone name/value use z,Z or X placeholders.\nTo serialize date or timestamp in UTC timezone, append 'Z' placeholder to the end: yyyy-MM-dd'T'HH:mm:ss'Z'\n\nThe following date/timestamp formats are also used as default during date/timestamp deserialization:\n   yyyy-MM-dd'T'HH:mm:ss\n   yyyy-MM-dd'T'HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss.SSSX\n   yyyy-MM-dd'T'HH:mm:ssXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXX\n   yyyy-MM-dd'T'HH:mm:ssXXX\n   yyyy-MM-dd'T'HH:mm:ss.SSSXXX\n   yyyy-MM-dd'T'HH:mm:ss z\n   yyyy-MM-dd'T'HH:mm:ss.SSS z\n\nDefault Dataspace formats (used in dataspace queries, and displayed in console):\n   yyyy-MM-dd HH:mm:ss - date\n   MM-yyyy-dd - sqldate\n   ss:HH:mm - sqltime\n   MM-yyyy-dd HH:mm:ss.SSS - sqltimestamp\n\nOther formats:\n\n   MM/dd/yy HH:mm:ss.SSS\n   yyyy-MM-dd'T'HH:mm:ssX\n   yyyy-MM-dd'T'HH:mm:ss'Z'\n\nDate unit samples:\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSSXXX')\n    date.toString(now(), 'yyyy-MM-dd HH:mm:ss.SSS z')\n    date.toString(now(), 'yyyy-MM-dd''T''HH:mm:ss.SSS''Z''')\n\n    date.fromString('2024-03-22T06:44:56.156Z')\n    date.fromString('2024-03-22T06:44:56.156+03')\n    date.fromString('2024-03-22T06:44:56.156 PST')\n\n");
        }

        public ToStringFunction() {
            super(metadata);
        }

        @Override
        protected Object convert(Object source, SimpleDateFormat format) throws ExpressionExecutionException {
            if (!(source instanceof Date)) {
                throw new ExpressionExecutionException("Parameter with wrong data type is passed to 'toString' function of 'date' function unit.", this);
            }
            return format.format((Date)source);
        }
    }

    static abstract class AbstractDateFunction
    extends AbstractFunctionExpression {
        protected AbstractDateFunction(FunctionMetaData metadata) {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            SimpleDateFormat format;
            this.checkArgumentNotNull(0);
            this.checkArgumentNotNull(1);
            if (!(((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value instanceof String)) {
                throw new ExpressionExecutionException("Date format pattern should be a string.", this);
            }
            try {
                JsonDateTimeSerializers.validJavaDateFormatOrThrowException((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value);
                format = new SimpleDateFormat((String)((Expression.ValueTypeResult)this.argumentsValues.get((int)1)).value);
            }
            catch (IllegalArgumentException error) {
                throw new ExpressionExecutionException("Invalid date pattern '" + (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value + "' specified.", this);
            }
            return this.makeExpressionResult(this.convert(((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value, format));
        }

        protected abstract Object convert(Object var1, SimpleDateFormat var2) throws ExpressionExecutionException;
    }
}

