/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.collection.AuditQueue;
import com.streamscape.cli.ds.collection.BlockingQueue;
import com.streamscape.cli.ds.collection.DirectoryTable;
import com.streamscape.cli.ds.collection.EventQueue;
import com.streamscape.cli.ds.collection.EventTable;
import com.streamscape.cli.ds.collection.FileTable;
import com.streamscape.cli.ds.collection.MessageQueue;
import com.streamscape.cli.ds.collection.ProcessQueue;
import com.streamscape.cli.ds.collection.SourceStream;
import com.streamscape.cli.ds.collection.Table;
import com.streamscape.cli.ds.collection.View;
import com.streamscape.cli.ds.collection.VirtualTable;
import com.streamscape.ds.jdbc.JDBCArray;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.accessor.ReadOnlyValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.expression.operation.AssignmentOperationExpression;
import com.streamscape.sef.evtrigger.function.expression.operation.CastOperation;
import com.streamscape.sef.evtrigger.function.statement.Variable;
import com.streamscape.sef.evtrigger.function.types.SemanticTypeType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.lexer.Token;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class DataspaceFunctionsUnit
extends AbstractFunctionsUnit
implements Closeable {
    private Set<String> systemDataspaceFunctions;
    private Set<String> userDataspaceFunctions;
    private String dataspaceName;
    private DataspaceAccessor dataspaceAccessor;
    private boolean isDefault;

    public DataspaceFunctionsUnit() {
        super(FunctionsUnitType.DS);
        this.registerFunction(QueryDataspaceFunction.class);
        this.registerFunction(LookupCollectionFunction.class);
        this.registerFunction(StartTransactionFunction.class);
        this.registerFunction(CommitFunction.class);
        this.registerFunction(RollbackFunction.class);
        this.registerFunction(SavepointFunction.class);
        this.registerFunction(SetAutocommitFunction.class);
        this.registerFunction(GetAutocommitFunction.class);
        this.registerFunction(SetFetchSizeFunction.class);
        this.registerFunction(GetFetchSizeFunction.class);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setDataspaceName(String dataspaceName) {
        if (this.dataspaceName != null && !this.dataspaceName.equals(dataspaceName)) {
            this.forceClose();
        }
        this.dataspaceName = dataspaceName;
    }

    public String getDataspaceName() {
        return this.dataspaceName;
    }

    public DataspaceAccessor getDataspaceAccessor(TriggerFunctionContext context) throws Exception {
        if (this.dataspaceAccessor == null) {
            this.dataspaceAccessor = context.createDataspaceAccessor(this.dataspaceName);
        }
        return this.dataspaceAccessor;
    }

    @Override
    public void close() throws IOException {
        if (!this.isDefault()) {
            this.forceClose();
        }
    }

    public void forceClose() {
        if (this.dataspaceAccessor != null) {
            this.dataspaceAccessor.close();
            this.dataspaceAccessor = null;
        }
        if (this.userDataspaceFunctions != null) {
            this.userDataspaceFunctions.clear();
            this.userDataspaceFunctions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> listSystemDataspaceFunctions(TriggerFunctionContext context) {
        if (this.systemDataspaceFunctions != null && !this.systemDataspaceFunctions.isEmpty()) {
            return this.systemDataspaceFunctions;
        }
        try (RowSet rowSet = null;){
            rowSet = this.getDataspaceAccessor(context).executeQuery("list functions (all)");
            this.systemDataspaceFunctions = new HashSet<String>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    this.systemDataspaceFunctions.add(rowSet.getString(2));
                }
            }
        }
        return this.systemDataspaceFunctions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> listUserDataspaceFunctions(TriggerFunctionContext context) {
        if (this.userDataspaceFunctions != null) {
            return this.userDataspaceFunctions;
        }
        try (RowSet rowSet = null;){
            rowSet = this.getDataspaceAccessor(context).executeQuery("list functions");
            this.userDataspaceFunctions = new HashSet<String>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    this.userDataspaceFunctions.add(rowSet.getString(1));
                }
            }
        }
        return this.userDataspaceFunctions;
    }

    @Override
    public Set<String> listFunctionNames(TriggerFunctionParserContext context) {
        HashSet<String> functionNames = new HashSet<String>(super.listFunctionNames(context));
        if (context instanceof TriggerFunctionContext) {
            functionNames.addAll(this.listSystemDataspaceFunctions((TriggerFunctionContext)context));
            functionNames.addAll(this.listUserDataspaceFunctions((TriggerFunctionContext)context));
        }
        return functionNames;
    }

    @Override
    protected Set<String> listFunctionNamesForComplete(TriggerFunctionParserContext context) {
        return super.listFunctionNames(context);
    }

    @Override
    public AbstractFunctionExpression lookupFunction(String name, TriggerFunctionParserContext context) {
        AbstractFunctionExpression function = super.lookupFunction(name, context);
        if (function != null) {
            return function;
        }
        return this.createDataspaceFunction(name);
    }

    public AbstractFunctionExpression createDataspaceFunction(String name) {
        DataspaceFunction function = new DataspaceFunction(name);
        function.setFunctionsUnit(this);
        return function;
    }

    public static class QueryDataspaceFunction
    extends AbstractDataspaceFunction {
        public static String NAME = "query";
        public static final FunctionMetaData metadata = QueryDataspaceFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData(NAME, TypeFactory.createObjectType(), FunctionMetaData.Arguments.builder().add("query", TypeFactory.STRING, "DSQL query").addOptionalRepeatable("params", TypeFactory.createObjectType(), "DQL query params, comma separated").build(), "Executes dataspace query. Variables can be referenced in query as @variable_name or as comma separated parameters(in this case in query thay should be marked as ?).\nIf query returns updateCount function returns int.\nIf query returns ResultSet function result depends on result columns count and cast or assignment variable type:\n   - if columns count more than 1 RowSet returned\n   - if columns count is zero null returned\n   - if result is casted to RowSet then RowSet returned\n   - if rows count more than 1 and columns count is 1 List returned\n   - if rows count is zero empty and columns count is 1 List returned\n   - if rows count is 1 and columns count is 1 and result is casted to any type(except List and RowSet) single value returned.");
        }

        public QueryDataspaceFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            this.checkArgumentNotNull(0);
            String query = (String)((Expression.ValueTypeResult)this.argumentsValues.get((int)0)).value;
            if (!(query instanceof String)) {
                throw this.argumentException(0, "Query should be not null and of string type.");
            }
            query = this.resolveQueryVariables(query);
            RowSet rowSet = null;
            try {
                Object[] arguments = new Object[this.argumentsValues.size() - 1];
                for (int i = 1; i < this.argumentsValues.size(); ++i) {
                    arguments[i - 1] = ((Expression.ValueTypeResult)this.argumentsValues.get((int)i)).value;
                }
                DataspaceAccessor accessor = this.getDataspaceAccessor(context);
                long currentRequestTimeout = accessor.getRequestTimeout();
                try {
                    accessor.setRequestTimeout(context.getExecutionWindowMs());
                    rowSet = accessor.executeQuery(query, arguments);
                }
                catch (Throwable exception) {
                    InterruptedException cause = Utils.getCause(exception, InterruptedException.class);
                    if (cause == null) {
                        accessor.setRequestTimeout(currentRequestTimeout);
                    }
                    throw exception;
                }
                accessor.setRequestTimeout(currentRequestTimeout);
                if (rowSet != null) {
                    if (rowSet.getClass().equals(RowSet.class) && rowSet.getRowMetaData().getColumnCount() == 1 && rowSet.getRowMetaData().getColumnName(1).equals("UpdateCount")) {
                        rowSet.next();
                        return new ReadOnlyValueAccessor(rowSet.getInt(1), TypeFactory.INT);
                    }
                } else {
                    return this.makeExpressionResult(null);
                }
                return this.convertResultSet(rowSet);
            }
            catch (Exception exception) {
                try {
                    if (rowSet != null) {
                        rowSet.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new ExpressionExecutionException("Unable to evaluate dataspace query. Cause: " + exception.getMessage(), this, exception);
            }
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ValueAccessor convertResultSet(RowSet rowSet) throws SQLException {
            boolean isListResult = true;
            boolean isRowSetResult = false;
            if (this.getParentExpression() != null && (this.getParentExpression() instanceof AssignmentOperationExpression || this.getParentExpression() instanceof CastOperation)) {
                isListResult = this.getParentExpression().getResultType() == TypeFactory.LIST;
                isRowSetResult = this.getParentExpression().getResultType() instanceof SemanticTypeType && ((SemanticTypeType)this.getParentExpression().getResultType()).getSemanticTypeName().equals("RowSet");
            }
            if (isRowSetResult) return new ReadOnlyValueAccessor(rowSet, TypeFactory.createSemanticTypeType("RowSet", RowSet.class.getName()));
            if (rowSet.getRowMetaData().getColumnCount() > 1) {
                return new ReadOnlyValueAccessor(rowSet, TypeFactory.createSemanticTypeType("RowSet", RowSet.class.getName()));
            }
            try {
                if (rowSet.getRowMetaData().getColumnCount() == 0) {
                    ValueAccessor valueAccessor = this.makeExpressionResult(null);
                    return valueAccessor;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                while (rowSet.next()) {
                    result.add(rowSet.getObject(1));
                }
                if (isListResult || result.isEmpty() || result.size() > 1) {
                    ReadOnlyValueAccessor readOnlyValueAccessor = new ReadOnlyValueAccessor(result, TypeFactory.LIST);
                    return readOnlyValueAccessor;
                }
                ValueAccessor valueAccessor = this.makeExpressionResult(result.get(0));
                return valueAccessor;
            }
            finally {
                try {
                    if (rowSet != null) {
                        rowSet.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        private String resolveQueryVariables(String query) throws ExpressionExecutionException {
            if (this.argumentsValues.size() > 1) {
                return query;
            }
            if (this.getParentBlock() == null) {
                throw this.argumentException(0, "Parent block is not set.");
            }
            StringBuilder builder = new StringBuilder();
            int lastPosition = 0;
            try {
                Lexer<LexerFactory.DummyTokenType> lexer = LexerFactory.createLexer(query);
                boolean isEnd = false;
                block6: while (!isEnd) {
                    Token<LexerFactory.DummyTokenType> token = lexer.readToken();
                    if (!token.isCommon()) continue;
                    switch (token.getCommonType()) {
                        case DOG: {
                            int dogBeginPosition = lexer.getCurrentTokenPosition();
                            token = lexer.readToken();
                            if (token.getCommonType() == CommonTokenType.LITERAL) {
                                String variableName = token.getValue();
                                Variable variable = this.getParentBlock().getVariablePool().getVariable(variableName);
                                if (variable == null) {
                                    throw this.argumentException(0, "Variable '" + variableName + "' doesn't exist.");
                                }
                                this.argumentsValues.add(new Expression.ValueTypeResult(variable.getValue(), variable.getType()));
                                builder.append(query.substring(lastPosition, dogBeginPosition)).append(" ? ");
                                lastPosition = lexer.getCurrentPosition();
                                break;
                            }
                            Trace.logError(this, "Unexpected token after @: " + token.toString() + ". query: " + query);
                            break;
                        }
                        case BUFFER_END: {
                            isEnd = true;
                            break;
                        }
                        default: {
                            continue block6;
                        }
                    }
                }
            }
            catch (LexerException exception) {
                Trace.logException(this, exception, false);
                return query;
            }
            if (lastPosition > 0 && lastPosition < query.length()) {
                builder.append(query.substring(lastPosition));
            }
            if (builder.length() > 0) {
                query = builder.toString();
            }
            return query;
        }
    }

    public static class LookupCollectionFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = LookupCollectionFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("lookupCollection", TypeFactory.DATASPACE_COLLECTION, FunctionMetaData.Arguments.builder().add("collectionName", TypeFactory.STRING, "collection name").build(), "Lookups specified collection in dataspace. Returns reference to collection if found, otherwise null.\nThe following collection references can be get: Queue, EventQueue, AuditQueue, MessageQueue, ProcessQueue, Table, EventTable, FileTable, VirtualTable, Directory, View, SourceStream.");
        }

        public LookupCollectionFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            String collectionName = (String)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
            try {
                DataCollection dataCollection = this.getDataspaceAccessor(context).lookupCollection(collectionName);
                if (dataCollection instanceof AuditQueue) {
                    this.setResultType(TypeFactory.AUDIT_QUEUE);
                } else if (dataCollection instanceof MessageQueue) {
                    this.setResultType(TypeFactory.MESSAGE_QUEUE);
                } else if (dataCollection instanceof ProcessQueue) {
                    this.setResultType(TypeFactory.PROCESS_QUEUE);
                } else if (dataCollection instanceof EventQueue) {
                    this.setResultType(TypeFactory.EVENT_QUEUE);
                } else if (dataCollection instanceof BlockingQueue) {
                    this.setResultType(TypeFactory.BLOCKING_QUEUE);
                } else if (dataCollection instanceof Table) {
                    this.setResultType(TypeFactory.TABLE);
                } else if (dataCollection instanceof EventTable) {
                    this.setResultType(TypeFactory.EVENT_TABLE);
                } else if (dataCollection instanceof FileTable) {
                    this.setResultType(TypeFactory.FILE_TABLE);
                } else if (dataCollection instanceof VirtualTable) {
                    this.setResultType(TypeFactory.VIRTUAL_TABLE);
                } else if (dataCollection instanceof DirectoryTable) {
                    this.setResultType(TypeFactory.DIRECTORY);
                } else if (dataCollection instanceof View) {
                    this.setResultType(TypeFactory.VIEW);
                } else if (dataCollection instanceof SourceStream) {
                    this.setResultType(TypeFactory.SOURCE_STREAM);
                } else if (dataCollection instanceof com.streamscape.cli.ds.collection.Map) {
                    this.setResultType(TypeFactory.createDataspaceMapType());
                } else if (dataCollection instanceof Map) {
                    this.setResultType(TypeFactory.createMapType());
                } else if (dataCollection instanceof com.streamscape.cli.ds.collection.Queue) {
                    this.setResultType(TypeFactory.createDataspaceQueueType());
                } else if (dataCollection instanceof Queue) {
                    this.setResultType(TypeFactory.createQueueType());
                } else {
                    throw new ExpressionExecutionException("Unsupportable collection type.", this);
                }
                return this.makeExpressionResult(dataCollection);
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to get get collection '" + collectionName + "'. Cause: " + exception.getMessage(), this, exception);
            }
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            super.validate(context);
        }

        @Override
        public Type<?> narrowTypeFor(Type<?> type) {
            if (type.getType() == Types.MAP) {
                return TypeFactory.createDataspaceMapType();
            }
            if (type.getType() == Types.QUEUE) {
                return TypeFactory.createDataspaceQueueType();
            }
            return type;
        }
    }

    public static class StartTransactionFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = StartTransactionFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("startTransaction", TypeFactory.VOIDTYPE, "Starts transaction in invoked dataspace. Can be replaced with DSQL query 'start transaction'.");
        }

        public StartTransactionFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                this.getDataspaceAccessor(context).executeQuery("start transaction");
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to start transaction. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }
    }

    public static class CommitFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = CommitFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("commit", TypeFactory.VOIDTYPE, "Commits transaction in invoked dataspace. Can be replaced with DSQL query 'commit'.");
        }

        public CommitFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                this.getDataspaceAccessor(context).commit();
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to commit transaction. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }
    }

    public static class RollbackFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = RollbackFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("rollback", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().addOptional("savepointName", TypeFactory.STRING, "savepoint name").build(), "Rollbacks transaction in invoked dataspace. Can be replaced with DSQL query 'rollback {to savepoint <savepoint>}'.");
        }

        public RollbackFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                String savepoint = null;
                if (this.arguments.size() > 0) {
                    savepoint = (String)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
                }
                if (savepoint != null) {
                    this.getDataspaceAccessor(context).executeQuery("rollback to savepoint " + savepoint);
                } else {
                    this.getDataspaceAccessor(context).rollback();
                }
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to rollback transaction. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }
    }

    public static class SavepointFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = SavepointFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("savepoint", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("savepointName", TypeFactory.STRING, "savepoint name").build(), "Sets savepoint with specified name in invoked dataspace. Can be replaced with DSQL query 'savepoint <savepoint>'.");
        }

        public SavepointFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                String savepointName = (String)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
                this.getDataspaceAccessor(context).executeQuery("savepoint " + savepointName);
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to rollback transaction. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }
    }

    public static class SetAutocommitFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = SetAutocommitFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setAutocommit", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("isAutocommit", TypeFactory.BOOLEAN, "true/false").build(), "Enables/disable autocommit in invoked dataspace. Can be replaced with DSQL query 'set autocommit {true | false}'.");
        }

        public SetAutocommitFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                Boolean isAutocommit = (Boolean)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
                this.getDataspaceAccessor(context).setAutoCommit(isAutocommit);
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to rollback transaction. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }
    }

    public static class GetAutocommitFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = GetAutocommitFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getAutocommit", TypeFactory.BOOLEAN, "Returns true if autocommit is enabled in invoked dataspace.");
        }

        public GetAutocommitFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                return this.makeExpressionResult(this.getDataspaceAccessor(context).getAutoCommit());
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to rollback transaction. Cause: " + exception.getMessage(), this, exception);
            }
        }
    }

    public static class SetFetchSizeFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = SetFetchSizeFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setFetchSize", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("fetchSize", TypeFactory.INT, "fetch rows count, default is 0").build(), "Sets fetch size in invoked dataspace. Fetch size works if RowSet returned only. If List returned all data will loaded.");
        }

        public SetFetchSizeFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                int fetchSize = (Integer)((AbstractExpression)this.arguments.get((int)0)).evaluateValueType((TriggerFunctionContext)context).value;
                this.getDataspaceAccessor(context).setFetchSize(fetchSize);
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to set fetch size. Cause: " + exception.getMessage(), this, exception);
            }
            return this.makeExpressionResult(null);
        }
    }

    public static class GetFetchSizeFunction
    extends AbstractDataspaceFunction {
        public static final FunctionMetaData metadata = GetFetchSizeFunction.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getFetchSize", TypeFactory.INT, "Returns fetch size in invoked dataspace.");
        }

        public GetFetchSizeFunction() {
            super(metadata);
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                return this.makeExpressionResult(this.getDataspaceAccessor(context).getFetchSize());
            }
            catch (DataspaceComponentException exception) {
                throw new ExpressionExecutionException("Failed to get fetch size. Cause: " + exception.getMessage(), this, exception);
            }
        }
    }

    public static class DataspaceFunction
    extends AbstractDataspaceFunction {
        private static FunctionMetaData createMetaData(String name) {
            return new FunctionMetaData(name, TypeFactory.createObjectType(), "See dataspace documentation.");
        }

        protected DataspaceFunction(String name) {
            super(DataspaceFunction.createMetaData(name));
        }

        @Override
        protected ValueAccessor onEvaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
            StringBuilder callString = new StringBuilder();
            callString.append("select ").append(this.getFunctionName());
            Object[] arguments = null;
            if (this.argumentsValues != null) {
                arguments = new Object[this.argumentsValues.size()];
                callString.append("(");
                for (int i = 0; i < this.argumentsValues.size(); ++i) {
                    if (i > 0) {
                        callString.append(", ");
                    }
                    callString.append("?");
                    arguments[i] = ((Expression.ValueTypeResult)this.argumentsValues.get((int)i)).value;
                }
                callString.append(")");
            }
            try (RowSet rowSet = null;){
                rowSet = this.getDataspaceAccessor(context).executeQuery(callString.toString(), arguments);
                if (rowSet.next()) {
                    Object value = rowSet.getObject(1);
                    if (value instanceof JDBCArray) {
                        JDBCArray jdbcArray = (JDBCArray)rowSet.getArray(1);
                        Object opaqueArray = jdbcArray.getArray();
                        SQLType arrayComponentType = SQLType.typeForId(jdbcArray.getBaseType());
                        Object typedArray = Array.newInstance(arrayComponentType.getTypeClass(), Array.getLength(opaqueArray));
                        System.arraycopy(opaqueArray, 0, typedArray, 0, Array.getLength(opaqueArray));
                        ValueAccessor valueAccessor = this.makeExpressionResult(typedArray);
                        return valueAccessor;
                    }
                    ValueAccessor valueAccessor = this.makeExpressionResult(value);
                    return valueAccessor;
                }
                ValueAccessor value = this.makeExpressionResult(null);
                return value;
            }
        }

        @Override
        public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
            DataspaceFunctionsUnit dataspaceFunctionUnit = (DataspaceFunctionsUnit)this.getFunctionsUnit();
            if (dataspaceFunctionUnit.getDataspaceName() != null && !dataspaceFunctionUnit.listSystemDataspaceFunctions(context).contains(this.getFunctionName()) && !dataspaceFunctionUnit.listUserDataspaceFunctions(context).contains(this.getFunctionName())) {
                throw new ExpressionExecutionException("Dataspace function '" + this.getFunctionName() + "' doesn't exist in dataspace '" + dataspaceFunctionUnit.getDataspaceName() + "'.", this);
            }
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.size(); ++i) {
                    ((AbstractExpression)this.arguments.get(i)).validate(context);
                }
            }
        }
    }

    static abstract class AbstractDataspaceFunction
    extends AbstractFunctionExpression {
        protected AbstractDataspaceFunction(FunctionMetaData metadata) {
            super(metadata);
        }

        protected DataspaceAccessor getDataspaceAccessor(TriggerFunctionContext context) throws ExpressionExecutionException {
            try {
                return ((DataspaceFunctionsUnit)this.getFunctionsUnit()).getDataspaceAccessor(context);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Unable to create dataspace accessor to dataspace '" + ((DataspaceFunctionsUnit)this.getFunctionsUnit()).getDataspaceName() + "'. Cause: " + exception.getMessage(), this, exception);
            }
        }
    }
}

