/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.Trace;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFunctionsUnit
extends FunctionsUnit {
    private Map<String, Class<? extends AbstractFunctionExpression>> functions = new HashMap<String, Class<? extends AbstractFunctionExpression>>();

    AbstractFunctionsUnit(FunctionsUnitType type) {
        super(type);
    }

    protected void registerFunction(Class<? extends AbstractFunctionExpression> functionClazz) {
        AbstractFunctionExpression function = this.instantiateFunctionExpression(functionClazz);
        if (this.functions.containsKey(function.getFunctionName())) {
            throw new RuntimeException("Function with name '" + function.getFunctionName() + "' already registered in unit '" + this.getType().getName() + "'.");
        }
        this.functions.put(function.getFunctionName(), functionClazz);
    }

    private AbstractFunctionExpression instantiateFunctionExpression(Class<? extends AbstractFunctionExpression> functionClazz) {
        try {
            AbstractFunctionExpression function = functionClazz.newInstance();
            return function;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate function from class '" + functionClazz.getName() + "'. Cause: " + exception.getMessage());
        }
    }

    @Override
    public Set<String> listFunctionNames(TriggerFunctionParserContext context) {
        return this.functions.keySet();
    }

    @Override
    public AbstractFunctionExpression lookupFunction(String name, TriggerFunctionParserContext context) {
        Class<? extends AbstractFunctionExpression> functionClazz = this.functions.get(name);
        if (functionClazz == null) {
            return null;
        }
        try {
            AbstractFunctionExpression function = this.instantiateFunctionExpression(functionClazz);
            function.setFunctionsUnit(this);
            return function;
        }
        catch (Exception exception) {
            Trace.logError(this, exception.getMessage());
            return null;
        }
    }
}

