/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.function;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ReadOnlyValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnit;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractFunctionExpression
extends AbstractExpression {
    protected List<AbstractExpression> arguments = null;
    protected List<Expression.ValueTypeResult> argumentsValues = null;
    protected FunctionMetaData metadata;
    private FunctionsUnit functionsUnit;

    protected AbstractFunctionExpression(FunctionMetaData metadata) {
        super(Priority.PRIORITY12);
        this.setResultType(metadata.getResultType());
        this.metadata = metadata;
    }

    public FunctionMetaData getMetaData() {
        return this.metadata;
    }

    public String getFunctionName() {
        return this.metadata.getFunctionName();
    }

    public void setFunctionsUnit(FunctionsUnit functionsUnit) {
        this.functionsUnit = functionsUnit;
    }

    public FunctionsUnit getFunctionsUnit() {
        return this.functionsUnit;
    }

    public void setArguments(List<AbstractExpression> arguments) {
        this.arguments = arguments;
    }

    public void setArguments(AbstractExpression ... arguments) {
        this.arguments = Arrays.asList(arguments);
    }

    public List<AbstractExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public final ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (this.arguments != null) {
            this.argumentsValues = new ArrayList<Expression.ValueTypeResult>();
            for (AbstractExpression argument : this.arguments) {
                this.argumentsValues.add(argument.evaluateValueType(context));
            }
        }
        return this.onEvaluate(context);
    }

    protected abstract ValueAccessor onEvaluate(TriggerFunctionContext var1) throws ExpressionExecutionException;

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (this.arguments.size() < this.metadata.getArguments().getMinArgumentsCount() || this.arguments.size() > this.metadata.getArguments().getMaxArgumentsCount()) {
            String message = "Invalid argument count in function '" + this.getFunctionName() + "' with signature '" + this.metadata.getFunctionSignature() + "'. ";
            message = this.metadata.getArguments().getMinArgumentsCount() == this.metadata.getArguments().getMaxArgumentsCount() ? (this.metadata.getArguments().getMinArgumentsCount() == 0 ? message + "Should be no arguments, " : message + "Should be " + this.metadata.getArguments().getMinArgumentsCount() + ", ") : message + "Should be from " + this.metadata.getArguments().getMinArgumentsCount() + " to " + this.metadata.getArguments().getMaxArgumentsCount() + ", ";
            message = message + "but found " + this.arguments.size() + ".";
            throw new ExpressionExecutionException(message, this);
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.get(i).validate(context);
            boolean isOk = false;
            for (Type<?> type : this.metadata.getArguments().getArgument(i).getTypes()) {
                try {
                    type.canConvert(this.arguments.get(i).getResultType());
                    isOk = true;
                    break;
                }
                catch (TypeConversionException typeConversionException) {
                }
            }
            if (isOk) continue;
            StringBuilder message = new StringBuilder();
            message.append("Invalid type of argument #").append(i + 1).append(" with name '").append(this.metadata.getArguments().getArgument(i).getName()).append("'");
            message.append(" in function '" + this.getFunctionName() + "'. Should be '");
            for (Type<?> type : this.metadata.getArguments().getArgument(i).getTypes()) {
                message.append(type.getName()).append(" | ");
            }
            message.setLength(message.length() - 3);
            message.append("', but found '").append(this.arguments.get(i).getResultType().getName()).append("'.");
            throw new ExpressionExecutionException(message.toString(), this.arguments.get(i));
        }
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (this.arguments == null) {
            return this;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.set(i, this.arguments.get(i).compile(context));
        }
        return this;
    }

    protected ValueAccessor makeExpressionResult(Object value) {
        return new ReadOnlyValueAccessor(value, this.getResultType());
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append(this.functionsUnit.getType().getName()).append(".").append(this.getFunctionName());
        if (this.arguments == null) {
            return;
        }
        builder.append("(");
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.arguments.get(i));
        }
        builder.append(")");
    }

    protected void checkArgumentNotNull(int index) throws ExpressionExecutionException {
        if (this.argumentsValues.get(index) == null) {
            throw this.argumentNullException(index);
        }
    }

    protected ExpressionExecutionException argumentNullException(int index) {
        return this.argumentException(index, "Null value is not allowed.");
    }

    protected ExpressionExecutionException argumentException(int index, String message) {
        return new ExpressionExecutionException("Validation of argument #" + (index + 1) + "(" + this.metadata.getArguments().getArgument(index).getName() + ") failed. " + message + ".\nFunction signature: '" + this.metadata.getFunctionSignature() + "'.", this.arguments.get(index));
    }

    public Type<?> narrowTypeFor(Type<?> type) {
        return type;
    }
}

