/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.ConstantExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.Variable;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.Type;

public abstract class VariableAccessorExpression
extends AbstractExpression
implements AssignableExpression {
    protected Variable variable;

    private VariableAccessorExpression(Variable variable) {
        super(Priority.PRIORITY1);
        this.variable = variable;
        this.setResultType(variable.getType());
    }

    public static VariableAccessorExpression create(Variable variable) {
        if (variable.isFinal()) {
            return new ConstantVariableAccessorExpressionImpl(variable);
        }
        return new VariableAccessorExpressionImpl(variable);
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        return this.variable;
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        return this;
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        EventType eventType;
        if (this.getResultType() instanceof EventType && (eventType = (EventType)this.getResultType()).getEventId() != null && eventType.getEventId().length() > 0 && (eventType.getSemanticTypeName() == null || eventType.getSemanticTypeClassName() == null)) {
            try {
                eventType.resolveEventType(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Variable getVariable() {
        return this.variable;
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append(this.variable.getName());
    }

    static class ConstantVariableAccessorExpressionImpl
    extends VariableAccessorExpression {
        ConstantVariableAccessorExpressionImpl(Variable variable) {
            super(variable);
        }

        @Override
        protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
            if (this.variable.isFinal() && this.variable.isInitialized()) {
                return new ConstantExpression(this.variable.getValue(), this.variable.getType());
            }
            return this;
        }
    }

    public static class VariableAccessorExpressionImpl
    extends VariableAccessorExpression {
        VariableAccessorExpressionImpl(Variable variable) {
            super(variable);
        }

        @Override
        public Type<?> getResultType() {
            if (this.variable != null) {
                return this.variable.getType();
            }
            return super.getResultType();
        }
    }
}

