/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ReadOnlyValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class ConstantExpression
extends AbstractExpression {
    private Object value;

    public ConstantExpression(Object value, Type<?> type) {
        super(Priority.PRIORITY1);
        this.value = value;
        this.setResultType(type);
        if (value instanceof String && TypeFactory.isHex((String)value)) {
            this.value = TypeFactory.fromHex((String)value);
        }
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        try {
            return new ReadOnlyValueAccessor(this.getResultType().convertValue(this.value, this.getResultType()), this.getResultType());
        }
        catch (ValueConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this, exception);
        }
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        try {
            this.getResultType().convertValue(this.value, this.getResultType());
        }
        catch (ValueConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this, exception);
        }
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append(this.getResultType().escapeValue(this.value));
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        return this;
    }
}

