/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression;

import com.streamscape.sef.evtrigger.function.AbstractPositional;
import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.ConstantExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.StatementBlock;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.slex.lang.completion.DSLCompletion;

public abstract class AbstractExpression
extends AbstractPositional
implements Expression {
    private Priority priority;
    private Type<?> resultType;
    protected boolean inBrackets = false;
    private StatementBlock parentBlock;
    private AbstractExpression parentExpression;

    public AbstractExpression(Priority priority) {
        this.priority = priority;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    protected void setResultType(Type<?> type) {
        this.resultType = type;
    }

    @Override
    public Type<?> getResultType() {
        return this.resultType;
    }

    public void setInBrackets(boolean inBrackets) {
        this.inBrackets = inBrackets;
    }

    public boolean isInBrackets() {
        return this.inBrackets;
    }

    public StatementBlock getParentBlock() {
        return this.parentBlock;
    }

    public void setParentBlock(StatementBlock parentBlock) {
        this.parentBlock = parentBlock;
    }

    public AbstractExpression getParentExpression() {
        return this.parentExpression;
    }

    public void setParentExpression(AbstractExpression parentExpression) {
        this.parentExpression = parentExpression;
    }

    public Expression.ValueTypeResult evaluateValueType(TriggerFunctionContext context) throws ExpressionExecutionException {
        ValueAccessor valueAccessor = this.evaluate(context);
        try {
            return new Expression.ValueTypeResult(valueAccessor.getValue(context), valueAccessor.getType());
        }
        catch (ValueConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this, exception);
        }
    }

    public AbstractExpression compile(TriggerFunctionContext context) throws ExpressionExecutionException {
        AbstractExpression compiled = this.onCompile(context);
        if (compiled != null && compiled != this) {
            compiled.setBeginEndPositions(this.getBeginPosition(), this.getEndPosition());
            compiled.setParentBlock(this.getParentBlock());
            compiled.setParentExpression(this.getParentExpression());
            AbstractExpression oldCompiled = null;
            while (oldCompiled != compiled && compiled != null) {
                oldCompiled = compiled;
                compiled = compiled.compile(context);
            }
        }
        return compiled;
    }

    protected abstract AbstractExpression onCompile(TriggerFunctionContext var1) throws ExpressionExecutionException;

    protected AbstractExpression createConstantExpressionWithClonePositional(Object value, Type<?> type) {
        ConstantExpression constantExpression = new ConstantExpression(value, type);
        this.clonePositionsTo(constantExpression);
        return constantExpression;
    }

    public DSLCompletion complete(TriggerFunctionContext context) throws ExpressionExecutionException {
        throw new ExpressionExecutionException("This expression doesn't support completion.", this);
    }

    @Override
    public void toString(StringBuilder builder) {
        if (this.inBrackets) {
            builder.append("(");
        }
        this.onToString(builder);
        if (this.inBrackets) {
            builder.append(")");
        }
    }

    protected abstract void onToString(StringBuilder var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }
}

