/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.condition;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ReadOnlyValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.condition.AbstractBinaryCondition;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class OrCondition
extends AbstractBinaryCondition {
    public OrCondition() {
        super("||", Priority.PRIORITY2);
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        Expression.ValueTypeResult[] results = new Expression.ValueTypeResult[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            results[i] = this.arguments[i].evaluateValueType(context);
            this.checkArgumentValueIsBoolean(results[i], i);
            if (!((Boolean)results[i].value).booleanValue()) continue;
            return new ReadOnlyValueAccessor(true, TypeFactory.BOOLEAN);
        }
        return new ReadOnlyValueAccessor(false, TypeFactory.BOOLEAN);
    }

    @Override
    protected Boolean onEvaluateResult(Expression.ValueTypeResult result1, Expression.ValueTypeResult result2, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        throw new ExpressionExecutionException("onEvaluateResult method is forbidden for class OrCondition.", this);
    }

    @Override
    protected void onValidate(Type<?> type1, Type<?> type2) throws ExpressionExecutionException, TypeConversionException {
        this.checkTypesNotNull(type1, type2);
        this.checkTypesAreBoolean(type1, type2);
    }
}

