/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.condition;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionTokenType;
import com.streamscape.sef.evtrigger.function.condition.AbstractBinaryCondition;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.util.Map;
import java.util.Queue;

public class InstanceofCondition
extends AbstractBinaryCondition {
    public InstanceofCondition() {
        super("instanceof", Priority.PRIORITY7);
    }

    @Override
    protected Boolean onEvaluateResult(Expression.ValueTypeResult result1, Expression.ValueTypeResult result2, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        if (result1.value == null) {
            return false;
        }
        Object value = result1.value;
        String typeName = (String)result2.value;
        Class clazz = null;
        if (typeName.equalsIgnoreCase(TriggerFunctionTokenType.MAP.getValue())) {
            clazz = Map.class;
        } else if (typeName.equalsIgnoreCase(TriggerFunctionTokenType.QUEUE.getValue())) {
            clazz = Queue.class;
        } else {
            try {
                Type<?> type = TypeFactory.createType(typeName, context);
                if (type == null) {
                    throw new ExpressionExecutionException("Type '" + typeName + "' not found.", this);
                }
                clazz = context.loadClass(type.getJavaClassName());
            }
            catch (ClassNotFoundException exception) {
                throw new ExpressionExecutionException("Failed to load class '" + typeName + "'.", this);
            }
        }
        return clazz.isAssignableFrom(value.getClass());
    }

    @Override
    protected void onValidate(Type<?> type1, Type<?> type2) throws ExpressionExecutionException, TypeConversionException {
    }
}

