/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.arrays;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;

public class ArrayLengthAccessorExpression
extends AbstractExpression {
    private AbstractExpression parentExpression;

    public ArrayLengthAccessorExpression(AbstractExpression parentExpression) {
        super(Priority.PRIORITY14);
        this.parentExpression = parentExpression;
        this.setResultType(TypeFactory.INT);
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        return new ArrayLengthAccessor();
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        Type<?> parentType = this.parentExpression.getResultType();
        if (parentType.getType() != Types.ARRAY && parentType.getType() != Types.OBJECT) {
            throw new ExpressionExecutionException("Failed to access field 'length' for object of type '" + parentType.getName() + "'.", this);
        }
        return this;
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.parentExpression.validate(context);
    }

    @Override
    protected void onToString(StringBuilder builder) {
        this.parentExpression.toString(builder);
        builder.append(".length");
    }

    class ArrayLengthAccessor
    implements ValueAccessor {
        @Override
        public Type<?> getType() {
            return ArrayLengthAccessorExpression.this.getResultType();
        }

        @Override
        public Object getValue(TriggerFunctionContext context) throws ExpressionExecutionException {
            Object parentValue = ArrayLengthAccessorExpression.this.parentExpression.evaluateValueType((TriggerFunctionContext)context).value;
            if (parentValue == null) {
                throw new ExpressionExecutionException("Failed to access 'length' in null object '" + ArrayLengthAccessorExpression.this.parentExpression.toString() + "'.", ArrayLengthAccessorExpression.this.parentExpression);
            }
            if (!parentValue.getClass().isArray()) {
                throw new ExpressionExecutionException("Failed to access 'length' in not array object '" + ArrayLengthAccessorExpression.this.parentExpression.toString() + "'.", ArrayLengthAccessorExpression.this.parentExpression);
            }
            return ((Object[])parentValue).length;
        }

        @Override
        public void assignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ExpressionExecutionException {
            throw new ExpressionExecutionException("Assign operation not allowed for array length.", ArrayLengthAccessorExpression.this.parentExpression);
        }

        @Override
        public String toString() {
            return ArrayLengthAccessorExpression.this.toString();
        }
    }
}

