/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.arrays;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.AbstractTransactionalValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionArgumentsException;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.operation.AbstractBinaryOperationExpression;
import com.streamscape.sef.evtrigger.function.types.ArrayType;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class ArrayElementAccessOperation
extends AbstractBinaryOperationExpression
implements AssignableExpression {
    public ArrayElementAccessOperation() {
        super("[]", Priority.PRIORITY14, false);
        this.setResultType(TypeFactory.createObjectType());
    }

    @Override
    protected void onValidateArguments() throws ExpressionArgumentsException {
        if (!(this.arguments[1] instanceof AbstractExpression)) {
            throw new ExpressionArgumentsException("Dot operations expects abstract expression as second argument.", this.arguments[1]);
        }
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        ArrayType parentArrayType;
        this.arguments[0] = this.arguments[0].compile(context);
        this.arguments[1] = this.arguments[1].compile(context);
        try {
            TypeFactory.INT.canConvert(this.arguments[1].getResultType());
        }
        catch (TypeConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this.arguments[1], exception);
        }
        Types parentType = this.arguments[0].getResultType().getType();
        if (parentType != Types.ARRAY && parentType != Types.OBJECT) {
            throw new ExpressionExecutionException("Failed to access array by index for object of type '" + this.arguments[0].getResultType().getName() + "'.", this);
        }
        if (parentType == Types.ARRAY && !((parentArrayType = (ArrayType)this.arguments[0].getResultType()).getElementType() instanceof ObjectType)) {
            this.setResultType(parentArrayType.getElementType());
        }
        return this;
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        return new ArrayElementByIndexAccessor(this.arguments[0].evaluate(context));
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
    }

    @Override
    protected Object onEvaluateResult(Expression.ValueTypeResult result1, Expression.ValueTypeResult result2, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        return null;
    }

    @Override
    protected void onValidate(Type<?> type1, Type<?> type2) throws ExpressionExecutionException, TypeConversionException {
    }

    @Override
    protected void onToString(StringBuilder builder) {
        this.arguments[0].toString(builder);
        builder.append("[");
        this.arguments[1].toString(builder);
        builder.append("]");
    }

    class ArrayElementByIndexAccessor
    extends AbstractTransactionalValueAccessor {
        ArrayElementByIndexAccessor(ValueAccessor parentValueAccessor) {
            super(parentValueAccessor);
        }

        @Override
        public Type<?> getType() {
            return ArrayElementAccessOperation.this.getResultType();
        }

        @Override
        protected Object onGetValue(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            return this.getSetValue(null, null, context, false);
        }

        @Override
        protected void onAssignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            this.getSetValue(value, valueType, context, true);
        }

        @Override
        protected void resolveTypeInRuntime(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            Object parentValue = this.parentValueAccessor.getValue(context);
            if (context == null || parentValue == null) {
                return;
            }
            Type<?> parentType = this.parentValueAccessor.getType();
            if ((parentType.getType() == Types.ARRAY && ((ArrayType)parentType).getElementType() instanceof ObjectType || parentType.getType() == Types.OBJECT) && parentValue.getClass().isArray()) {
                ArrayElementAccessOperation.this.setResultType(TypeFactory.resolveType(parentValue.getClass().getComponentType(), (SemanticTypeLookupContext)context));
            }
        }

        private Object getSetValue(Object value, Type<?> valueType, TriggerFunctionContext context, boolean isSet) throws ExpressionExecutionException, ValueConversionException {
            Object parentValue = this.parentValueAccessor.getValue(context);
            if (parentValue == null) {
                throw new ExpressionExecutionException("Failed to access array element on null object '" + ArrayElementAccessOperation.this.arguments[0].toString() + "'.", ArrayElementAccessOperation.this.arguments[0]);
            }
            if (!parentValue.getClass().isArray()) {
                throw new ExpressionExecutionException("Failed to access array element on object of not array type '" + ArrayElementAccessOperation.this.arguments[0].toString() + "'.", ArrayElementAccessOperation.this.arguments[0]);
            }
            try {
                Expression.ValueTypeResult indexResult = ArrayElementAccessOperation.this.arguments[1].evaluateValueType(context);
                int index = TypeFactory.INT.convertValue(indexResult.value, indexResult.type);
                Object[] parentArrayValue = (Object[])parentValue;
                if (index > parentArrayValue.length || index < 0) {
                    throw new ExpressionExecutionException("Index " + index + " out of bounds [0, " + parentArrayValue.length + ").", ArrayElementAccessOperation.this.arguments[1]);
                }
                Object result = null;
                if (isSet) {
                    parentArrayValue[index] = this.getType().convertValue(value, valueType);
                } else {
                    result = parentArrayValue[index];
                }
                return result;
            }
            catch (ValueConversionException exception) {
                throw new ExpressionExecutionException(exception.getMessage(), ArrayElementAccessOperation.this, exception);
            }
        }

        @Override
        public String toString() {
            return ArrayElementAccessOperation.this.toString();
        }
    }
}

