/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.accessor;

import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.TransactionalValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public abstract class AbstractTransactionalValueAccessor
implements TransactionalValueAccessor {
    protected ValueAccessor parentValueAccessor;
    private boolean isInitialized;
    private Object lastValue;
    private boolean isUpdateOnValueAssign;

    protected AbstractTransactionalValueAccessor(ValueAccessor parentValueAccessor) {
        this.parentValueAccessor = parentValueAccessor;
    }

    @Override
    public Object getValue(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        if (!this.isInitialized) {
            this.parentValueAccessor.getValue(context);
            this.resolveTypeInRuntime(context);
            this.lastValue = this.onGetValue(context);
            if (context != null && this.lastValue != null && this.getType().getType() == Types.OBJECT) {
                ((ObjectType)this.getType()).setRealType(TypeFactory.resolveObjectType(this.lastValue, context));
            }
            this.isInitialized = true;
        }
        return this.lastValue;
    }

    @Override
    public void assignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        this.parentValueAccessor.getValue(context);
        if (!this.isInitialized) {
            this.resolveTypeInRuntime(context);
        }
        this.onAssignValue(value, valueType, context);
        this.valueChanged(context);
    }

    protected abstract Object onGetValue(TriggerFunctionContext var1) throws ExpressionExecutionException, ValueConversionException;

    protected abstract void onAssignValue(Object var1, Type<?> var2, TriggerFunctionContext var3) throws ExpressionExecutionException, ValueConversionException;

    protected abstract void resolveTypeInRuntime(TriggerFunctionContext var1) throws ExpressionExecutionException, ValueConversionException;

    @Override
    public void valueChanged(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        if (this.isUpdateOnValueAssign && this.lastValue != null) {
            this.onAssignValue(this.lastValue, this.parentValueAccessor.getType(), context);
        }
        if (this.parentValueAccessor instanceof TransactionalValueAccessor) {
            ((TransactionalValueAccessor)this.parentValueAccessor).valueChanged(context);
        }
    }

    public void updateOnValueAssign() {
        this.isUpdateOnValueAssign = true;
    }
}

