/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function;

import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.TriggerFunctionContextImpl;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionDisableException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionInvalidateException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParser;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.StatementBlock;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.tools.lexer.BufferUtils;
import com.streamscape.tools.parser.AbstractParserException;

public class TriggerScript {
    private TriggerFunctionContextImpl triggerFunctionContext;
    private AbstractExpression whenExpression;
    private StatementBlock statement;
    private EventTriggerCompiledDefinition compiledDefinition;

    private TriggerScript() {
    }

    public static TriggerScript parseAndCompile(EventTriggerDefinition definition, FabricComponent component, FabricContext context) throws Exception {
        TriggerScript result = new TriggerScript();
        result.parseAndCompileInternal(definition, component, context);
        return result;
    }

    private void parseAndCompileInternal(EventTriggerDefinition definition, FabricComponent component, FabricContext context) throws Exception {
        if (definition.getTriggerScript() == null || definition.getTriggerScript().length() == 0) {
            throw new Exception("Trigger script is empty.");
        }
        TriggerFunctionContextImpl triggerFunctionParserContext = this.triggerFunctionContext = new TriggerFunctionContextImpl(context);
        String actionEventId = null;
        String sourceEventId = null;
        if (definition.getEventHandlerName() != null && component instanceof ServiceContext) {
            try {
                actionEventId = ((ServiceContext)component).getEventHandler(definition.getEventHandlerName()).getRequestEventId();
            }
            catch (ServiceConfigurationException e) {
                throw new Exception("Event handler '" + definition.getEventHandlerName() + "' doesn't.");
            }
            sourceEventId = actionEventId;
        } else if (definition.getActionableEventId() != null) {
            actionEventId = definition.getActionableEventId();
            if (component instanceof ServiceContext) {
                for (EventHandler handler : ((ServiceContext)component).getEventHandlers()) {
                    if (!actionEventId.equals(handler.getResponseEventId())) continue;
                    sourceEventId = handler.getRequestEventId();
                }
            }
            if (sourceEventId == null) {
                sourceEventId = actionEventId;
            }
        }
        if (actionEventId == null) {
            throw new Exception("No actionable event defined for trigger " + definition.getName());
        }
        triggerFunctionParserContext.setActionableEventType(actionEventId);
        if (definition.getSourceEventAlias() != null && definition.getSourceEventAlias().length() > 0) {
            triggerFunctionParserContext.setSourceEventAlias(definition.getSourceEventAlias(), sourceEventId);
        }
        if (definition.getActionableEventAlias() != null && definition.getActionableEventAlias().length() > 0) {
            triggerFunctionParserContext.setActionableEventAlias(definition.getActionableEventAlias());
        }
        this.triggerFunctionContext.setComponent(component);
        this.triggerFunctionContext.setEventTriggerDefinition(definition);
        TriggerFunctionParser parser = new TriggerFunctionParser(triggerFunctionParserContext);
        if (definition.getEventSelector() != null && definition.getEventSelector().length() > 0) {
            try {
                this.whenExpression = parser.parseExpression(definition.getEventSelector());
                this.whenExpression.compile(this.triggerFunctionContext);
            }
            catch (Exception exception) {
                throw new Exception("When expression parsing failed. Cause: " + exception.getMessage());
            }
        }
        try {
            this.statement = (StatementBlock)parser.parse(definition.getTriggerScript());
            this.statement.compile(this.triggerFunctionContext);
        }
        catch (AbstractParserException exception) {
            int position = BufferUtils.getAbsolutePosition(definition.getTriggerScript(), exception.getLineNumber(), exception.getPositionInLine() > 0 ? exception.getPositionInLine() - 1 : 0);
            BufferUtils.setLineAndPositions(exception, definition.getFullSyntax(), position += definition.getFullSyntax().indexOf(definition.getTriggerScript(), BufferUtils.skipSpacesAndCommends(definition.getFullSyntax(), 0)));
            throw exception;
        }
        this.compiledDefinition = new EventTriggerCompiledDefinition(definition);
        this.compiledDefinition.setRaisedEventIds(this.statement.getStatementContext().listRaisedEventIds());
        this.compiledDefinition.setUsedEventIds(this.statement.getStatementContext().listUsedEventIds());
        this.compiledDefinition.setAdvisoryCapable(this.statement.getStatementContext().isRaiseAdvisory());
        this.disable();
    }

    public void validate() throws Exception {
        if (this.whenExpression != null) {
            try {
                this.whenExpression.validate(this.triggerFunctionContext);
                if (this.whenExpression.getResultType() != TypeFactory.BOOLEAN) {
                    throw new Exception("When expression should return type BOOLEAN, but returns " + this.whenExpression.getResultType().getName());
                }
            }
            catch (Exception exception) {
                throw new Exception("When expression validation failed. Cause: " + exception.getMessage());
            }
        }
        this.statement.validate(this.triggerFunctionContext);
        this.disable();
    }

    public EventTriggerCompiledDefinition getDefinition() {
        return this.compiledDefinition;
    }

    public boolean isEventIdForReply(String eventId) {
        return this.statement != null && this.statement.getStatementContext().isEventIdForReply(eventId);
    }

    public void disable() {
        if (this.statement != null) {
            this.statement.getStatementContext().getDefaultDataspaceFunctionsUnit().forceClose();
            this.statement.reset(true);
        }
        this.triggerFunctionContext.closeSLSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(ImmutableEventDatagram actionableEvent, ImmutableEventDatagram sourceEvent, long executionWindowMs, TriggerFunctionContextImpl.DataspaceAccessorProvider dataspaceAccessorProvider) throws TriggerFunctionException {
        this.triggerFunctionContext.setActionableEvent(actionableEvent);
        this.triggerFunctionContext.setSourceEvent(sourceEvent);
        this.triggerFunctionContext.setExecutionWindowMs(executionWindowMs);
        this.triggerFunctionContext.setDataspaceAccessorProvider(dataspaceAccessorProvider);
        try {
            if (this.whenExpression != null) {
                try {
                    this.whenExpression.getParentBlock().initializeVariables(this.triggerFunctionContext);
                    Object value = this.whenExpression.evaluateValueType((TriggerFunctionContext)this.triggerFunctionContext).value;
                    if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) {
                        return;
                    }
                }
                catch (ExpressionExecutionException exception) {
                    throw new TriggerFunctionException("Failed to execute when expression. Error: " + exception.getMessage(), exception);
                }
            }
            try {
                this.statement.execute(this.triggerFunctionContext);
            }
            catch (TriggerFunctionDisableException | TriggerFunctionInvalidateException exception) {
                this.disable();
                throw exception;
            }
        }
        finally {
            this.statement.reset(false);
        }
    }
}

