/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function;

import com.streamscape.sef.evtrigger.function.statement.Variable;
import com.streamscape.sef.evtrigger.function.statement.VariablePool;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TypedParameterSuggestion;
import java.util.ArrayList;

public class TriggerFunctionVariableCompleter
implements PrefixCompleter {
    private VariablePool variablePool;

    public TriggerFunctionVariableCompleter(VariablePool variablePool) {
        this.variablePool = variablePool;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Variable variable : this.variablePool.getAllHierarchyVariables()) {
            if (prefix != null && prefix.length() != 0 && !variable.getName().startsWith(prefix)) continue;
            variableNames.add(variable.getName());
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, variableNames);
        if (completion != null) {
            for (String variableName : variableNames) {
                Suggestion suggestion = new TypedParameterSuggestion(variableName, this.variablePool.getVariable(variableName).getType().getName(), SuggestionGroup.VARIABLE).setOffset(prefix);
                completion.addSuggestion(suggestion);
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

