/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function;

import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.tools.lexer.TokenType;

public enum TriggerFunctionTokenType implements TokenType
{
    STRING(Types.STRING.getName()),
    INT(Types.INT.getName()),
    INTEGER(Types.INT.getAlias()),
    SHORT(Types.SHORT.getName()),
    LONG(Types.LONG.getName()),
    FLOAT(Types.FLOAT.getName()),
    DOUBLE(Types.DOUBLE.getName()),
    BIGDECIMAL(Types.BIGDECIMAL.getName()),
    BIGINT(Types.BIGINT.getName()),
    BIGINTEGER(Types.BIGINT.getAlias()),
    BOOLEAN(Types.BOOLEAN.getName()),
    CHAR(Types.CHAR.getName()),
    BYTE(Types.BYTE.getName()),
    DATE(Types.DATE.getName()),
    SQL_DATE(Types.SQL_DATE.getName()),
    SQL_TIMESTAMP(Types.SQL_TIMESTAMP.getName()),
    EVENT(Types.EVENT.getName()),
    OBJECT(Types.OBJECT.getName()),
    LIST(Types.LIST.getName()),
    SET(Types.SET.getName()),
    COLLECTION(Types.COLLECTION.getName()),
    QUEUE(Types.QUEUE.getName()),
    ITERABLE(Types.ITERABLE.getName()),
    MAP(Types.MAP.getName()),
    DATASPACE(Types.DATASPACE.getName()),
    SERVICE(Types.SERVICE.getName()),
    RUNTIME(Types.RUNTIME.getName()),
    BLOCKING_QUEUE(Types.BLOCKING_QUEUE.getName()),
    EVENT_QUEUE(Types.EVENT_QUEUE.getName()),
    AUDIT_QUEUE(Types.AUDIT_QUEUE.getName()),
    MESSAGE_QUEUE(Types.MESSAGE_QUEUE.getName()),
    PROCESS_QUEUE(Types.PROCESS_QUEUE.getName()),
    TABLE(Types.TABLE.getName()),
    EVENT_TABLE(Types.EVENT_TABLE.getName()),
    FILE_TABLE(Types.FILE_TABLE.getName()),
    VIRTUAL_TABLE(Types.VIRTUAL_TABLE.getName()),
    DIRECTORY(Types.DIRECTORY.getName()),
    VIEW(Types.VIEW.getName()),
    SOURCE_STREAM(Types.SOURCE_STREAM.getName()),
    ENTRY(Types.ENTRY.getName()),
    ROW(Types.ROW.getName()),
    ROWSET(Types.ROWSET.getName()),
    ROWARRAY(Types.ROWARRAY.getName()),
    INSTANCEOF("instanceof"),
    FINAL("final"),
    DECLARE("declare"),
    TRANSIENT("transient"),
    TRUE("true"),
    FALSE("false"),
    WHILE("while"),
    BREAK("break"),
    CONTINUE("continue"),
    RETURN("return"),
    FOR("for"),
    IF("if"),
    ELSE("else"),
    TRY("try"),
    CATCH("catch"),
    FINALLY("finally"),
    THROW("throw"),
    RAISE("raise"),
    ON("on"),
    ADVISORY("advisory"),
    EXCEPTION("exception"),
    NEW("new"),
    NULL("null"),
    SELECT("select"),
    INSERT("insert"),
    UPDATE("update"),
    DELETE("delete"),
    CREATE("create"),
    DROP("drop"),
    CALL("call"),
    START("start"),
    COMMIT("commit"),
    ROLLBACK("rollback"),
    SAVEPOINT("savepoint"),
    EXEC("exec");

    private String value;
    private boolean isDelimiter = false;
    private boolean isCaseSensitive = false;

    private TriggerFunctionTokenType(String value) {
        this(value, false);
    }

    private TriggerFunctionTokenType(String value, boolean isCaseSensitive) {
        this(value, isCaseSensitive, false);
    }

    private TriggerFunctionTokenType(String value, boolean isCaseSensitive, boolean isDelimiter) {
        this.value = value;
        this.isCaseSensitive = isCaseSensitive;
        this.isDelimiter = isDelimiter;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isDelimiter() {
        return this.isDelimiter;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public static TriggerFunctionTokenType parse(String value) {
        if (value == null) {
            return null;
        }
        for (TriggerFunctionTokenType t : TriggerFunctionTokenType.values()) {
            if ((!t.isCaseSensitive() || !t.value.equals(value)) && (t.isCaseSensitive() || !t.value.equalsIgnoreCase(value))) continue;
            return t;
        }
        return null;
    }
}

