/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function;

import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.AdvisoryDatagramFactory;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.excp.ExceptionDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.mf.admin.FabricContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TriggerFunctionParserContextImpl
implements TriggerFunctionParserContext {
    protected FabricContext fabricContext;
    protected DatagramPrototypeCache datagramPrototypeCache;
    protected EventDatagramFactory eventDatagramFactory;
    protected ExceptionDatagramFactory exceptionDatagramFactory;
    protected AdvisoryDatagramFactory advisoryDatagramFactory;
    protected OpaqueDatagramFactory opaqueDatagramFactory;
    protected String actionableEventAlias = "ACTIONABLE_EVENT";
    protected String sourceEventAlias = null;
    private Map<String, Type<?>> systemVariableTypes = new HashMap();
    private boolean isCompleteMode;

    public TriggerFunctionParserContextImpl(FabricContext fabricContext) {
        this.fabricContext = fabricContext;
        this.datagramPrototypeCache = fabricContext.getDatagramPrototypeCache();
        this.eventDatagramFactory = fabricContext.getEventDatagramFactory();
        this.exceptionDatagramFactory = fabricContext.getExceptionDatagramFactory();
        this.advisoryDatagramFactory = fabricContext.getAdvisoryDatagramFactory();
        this.opaqueDatagramFactory = fabricContext.getOpaqueDatagramFactory();
    }

    @Override
    public FabricContext getFabricContext() {
        return this.fabricContext;
    }

    @Override
    public Prototype lookupEventPrototype(String eventId) {
        return this.datagramPrototypeCache.lookupPrototype(eventId);
    }

    public ImmutableEventDatagram createEvent(String eventId) throws DatagramFactoryException {
        Prototype prototype = this.lookupEventPrototype(eventId);
        if (prototype == null) {
            return null;
        }
        if (this.eventDatagramFactory.supportsModel(prototype.getModelName())) {
            return this.eventDatagramFactory.createEvent(eventId);
        }
        if (this.exceptionDatagramFactory.supportsModel(prototype.getModelName())) {
            return this.exceptionDatagramFactory.createEvent(eventId);
        }
        if (this.advisoryDatagramFactory.supportsModel(prototype.getModelName())) {
            return this.advisoryDatagramFactory.createEvent(eventId);
        }
        if (this.opaqueDatagramFactory.supportsModel(prototype.getModelName())) {
            return this.opaqueDatagramFactory.createEvent(eventId);
        }
        return null;
    }

    @Override
    public SemanticType lookupSemanticType(String semanticTypeName) {
        return this.fabricContext.getSemanticTypeCache().lookupSemanticType(semanticTypeName);
    }

    @Override
    public SemanticType lookupSemanticTypeByClass(String className) {
        return this.fabricContext.getSemanticTypeCache().lookupSemanticClass(className);
    }

    @Override
    public List<String> listSemanticTypes() {
        return this.fabricContext.getSemanticTypeCache().listSemanticTypes();
    }

    @Override
    public boolean existsSemanticType(String semanticTypeName) {
        return this.fabricContext.getSemanticTypeCache().existsSemanticType(semanticTypeName);
    }

    @Override
    public boolean existsSemanticTypeByClass(String className) {
        return this.fabricContext.getSemanticTypeCache().existsSemanticClass(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return ClassUtils.loadClass(className, this.fabricContext.getSystemClassLoaderChain());
    }

    @Override
    public Class<?> loadClass(SemanticType semanticType) throws ClassNotFoundException {
        return this.loadClass(semanticType.getClassName());
    }

    @Override
    public boolean needToReload(Class<?> clazz) {
        return clazz == null || clazz.getClassLoader() instanceof FabricClassLoader && !((FabricClassLoader)clazz.getClassLoader()).isLoaded();
    }

    @Override
    public boolean needToReload(Field field) {
        return field == null || this.needToReload(field.getDeclaringClass()) || this.needToReload(field.getType());
    }

    @Override
    public boolean needToReload(Method method) {
        boolean result;
        boolean bl = result = method == null || this.needToReload(method.getDeclaringClass()) || this.needToReload(method.getReturnType());
        if (result) {
            return result;
        }
        for (Class<?> clazz : method.getParameterTypes()) {
            if (!this.needToReload(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean existsSystemVariableType(String name) {
        return this.systemVariableTypes.containsKey(name);
    }

    @Override
    public Type<?> getSystemVariableType(String name) {
        return this.systemVariableTypes.get(name);
    }

    public void addSystemVariableType(String name, Type<?> type) {
        this.systemVariableTypes.put(name, type);
    }

    public void addSystemVariableType(String name, Class<?> clazz) throws Exception {
        Type<?> type = TypeFactory.resolveType(clazz, (SemanticTypeLookupContext)this);
        if (type == null) {
            throw new Exception("Failed to resolve type of class '" + clazz.getName() + "'.");
        }
        this.addSystemVariableType(name, type);
    }

    public void setActionableEventType(String eventModel, Class<?> eventClazz, String eventId) {
        this.setActionableEventType(TypeFactory.createEventType(eventModel, eventClazz, eventId));
    }

    public void setActionableEventType(String eventId) throws Exception {
        this.setActionableEventType(TypeFactory.createEventType(eventId));
    }

    public void setActionableEventType(Type<?> type) {
        this.addSystemVariableType(this.actionableEventAlias, type);
    }

    @Override
    public Type<?> getActionableEventType() {
        return this.getSystemVariableType(this.actionableEventAlias);
    }

    public void setActionableEventAlias(String actionableEventAlias) {
        Type<?> type = this.systemVariableTypes.remove(this.actionableEventAlias);
        if (type != null) {
            this.systemVariableTypes.put(actionableEventAlias, type);
        }
        this.actionableEventAlias = actionableEventAlias;
    }

    public void setSourceEventAlias(String sourceEventAlias) throws Exception {
        this.setSourceEventAlias(sourceEventAlias, null);
    }

    public void setSourceEventAlias(String sourceEventAlias, String sourceEventId) throws Exception {
        this.sourceEventAlias = sourceEventAlias;
        this.addSystemVariableType(sourceEventAlias, TypeFactory.createEventType(sourceEventId));
    }

    public void validateSystemVariableTypes() throws TriggerFunctionException {
        for (Map.Entry<String, Type<?>> entry : this.systemVariableTypes.entrySet()) {
            if (!(entry.getValue() instanceof EventType)) continue;
            EventType eventType = (EventType)entry.getValue();
            if (eventType.getEventId() == null || eventType.getEventId().length() == 0) {
                throw new TriggerFunctionException("EventId is not set for System variable '" + entry.getKey() + "' of event type.");
            }
            try {
                eventType.resolveEventType(this);
            }
            catch (Exception exception) {
                throw new TriggerFunctionException("Failed to create event type for variable '" + String.valueOf(entry.getValue()) + ". Cause: " + exception.getMessage());
            }
        }
    }

    @Override
    public boolean isCompleteMode() {
        return this.isCompleteMode;
    }

    @Override
    public void setCompleteMode(boolean isCompleteMode) {
        this.isCompleteMode = isCompleteMode;
    }
}

