/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.file;

import com.streamscape.lib.txfs.FileTransaction;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import com.streamscape.lib.txfs.exceptions.TransactionException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sef.evtrigger.file.AbstractTransactionalDestinationFileActionStrategy;
import java.io.File;

public class RenameFileActionStrategy
extends AbstractTransactionalDestinationFileActionStrategy {
    public RenameFileActionStrategy(String destinationPath, String tempDirectory, boolean sendContent) {
        super(destinationPath, tempDirectory, sendContent);
        this.isEval = true;
    }

    @Override
    protected void doInTransaction(FileTransaction tx, FileEvent changeEvent) throws TransactionException {
        try {
            String dstPath = this.parseDestinationPath();
            String srcPath = changeEvent.getPath();
            File srcFile = new File(srcPath);
            File dstFile = new File(dstPath);
            if (!srcFile.toPath().normalize().toAbsolutePath().getParent().equals(dstFile.toPath().normalize().toAbsolutePath().getParent())) {
                throw new ResourceException("Files must have the same parent folder.");
            }
            if (srcFile.isDirectory()) {
                tx.renameFolder(srcPath, dstFile.getName());
            } else {
                tx.moveFile(srcPath, dstPath);
            }
        }
        catch (SecurityViolationException e) {
            e.printStackTrace();
        }
    }
}

