/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.file;

import com.streamscape.Trace;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.evtrigger.file.AbstractTransactionalFileActionStrategy;
import com.streamscape.sef.evtrigger.file.CopyFileActionStrategy;
import com.streamscape.sef.evtrigger.file.DeleteFileActionStrategy;
import com.streamscape.sef.evtrigger.file.FileActionStrategy;
import com.streamscape.sef.evtrigger.file.MoveFileActionStrategy;
import com.streamscape.sef.evtrigger.file.RenameFileActionStrategy;
import com.streamscape.sef.evtrigger.file.SendFileActionStrategy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileActionStrategyFactory {
    static final Pattern ACTION_PATTERN = Pattern.compile("(?i)^\\s*(SEND)?\\s*(AND)?\\s*(RENAME|COPY|DELETE|MOVE)\\s*(?:'([^\\']+){1}')?\\s*(FILE)?\\s*(?:(AS|TO)\\s+'([^\\']+){1}')?\\s*");

    private FileActionStrategyFactory() {
    }

    public static FileActionStrategy chooseStrategy(String script) throws InvalidEventTriggerSyntaxException {
        Trace.logDebug(FileActionStrategyFactory.class, "Choosing FileAction Strategy for: " + script);
        String tempDir = System.getProperty("EVFSDaemon.txlog.dir", ".txlog");
        Matcher matcher = ACTION_PATTERN.matcher(script);
        if (matcher.find()) {
            AbstractTransactionalFileActionStrategy trigger;
            boolean sendFileContent = matcher.group(1) != null;
            boolean compountAction = matcher.group(2) != null;
            String type = matcher.group(3);
            if (compountAction && type == null) {
                throw new InvalidEventTriggerSyntaxException("Invalid event trigger syntax. Second action is not specified.");
            }
            if (sendFileContent && !compountAction) {
                if (type != null) {
                    throw new InvalidEventTriggerSyntaxException("Invalid event trigger syntax '" + script + "' specified.");
                }
                type = "SEND";
            }
            String sourceFile = matcher.group(4);
            String asOrTo = matcher.group(6);
            String destDir = matcher.group(7);
            FileActionStrategy.FileActionStrategyType fileActionStrategyType = FileActionStrategy.FileActionStrategyType.valueOf(type.toUpperCase());
            switch (fileActionStrategyType) {
                case COPY: {
                    FileActionStrategyFactory.checkDestDir(destDir, fileActionStrategyType);
                    trigger = new CopyFileActionStrategy(destDir, tempDir, sendFileContent);
                    ((CopyFileActionStrategy)trigger).setEvalDestinationPath("AS".equalsIgnoreCase(asOrTo));
                    Trace.logDebug(FileActionStrategyFactory.class, "CopyFileActionStrategy is chosen");
                    break;
                }
                case RENAME: {
                    FileActionStrategyFactory.checkDestDir(destDir, fileActionStrategyType);
                    trigger = new RenameFileActionStrategy(destDir, tempDir, sendFileContent);
                    Trace.logDebug(FileActionStrategyFactory.class, "RenameFileActionStrategy is chosen");
                    break;
                }
                case MOVE: {
                    FileActionStrategyFactory.checkDestDir(destDir, fileActionStrategyType);
                    trigger = new MoveFileActionStrategy(destDir, tempDir, sendFileContent);
                    Trace.logDebug(FileActionStrategyFactory.class, "MoveFileActionStrategy is chosen");
                    break;
                }
                case DELETE: {
                    trigger = new DeleteFileActionStrategy(tempDir, sendFileContent);
                    Trace.logDebug(FileActionStrategyFactory.class, "DeleteFileActionStrategy is chosen");
                    break;
                }
                case SEND: {
                    trigger = new SendFileActionStrategy(tempDir);
                    Trace.logDebug(FileActionStrategyFactory.class, "SendFileActionStrategy is chosen");
                    break;
                }
                default: {
                    throw new InvalidEventTriggerSyntaxException("Unknown file trigger type");
                }
            }
            if (sourceFile != null) {
                trigger.setSourceFilePath(sourceFile);
            }
            return trigger;
        }
        throw new InvalidEventTriggerSyntaxException("Wrong action script for FileAction");
    }

    public static void validateSyntax(String syntax) throws InvalidEventTriggerSyntaxException {
        if (!ACTION_PATTERN.matcher(syntax).matches()) {
            throw new InvalidEventTriggerSyntaxException("Invalid syntax at '" + syntax + "'");
        }
    }

    private static void checkDestDir(String destDir, FileActionStrategy.FileActionStrategyType fileActionStrategyType) throws InvalidEventTriggerSyntaxException {
        if (destDir == null) {
            throw new InvalidEventTriggerSyntaxException("Destination path for " + String.valueOf((Object)fileActionStrategyType) + " trigger is undefined");
        }
    }
}

