/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.file;

import com.streamscape.ds.lib.FileUtil;
import com.streamscape.lib.txfs.FileTransaction;
import com.streamscape.lib.txfs.exceptions.TransactionException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sef.evtrigger.file.AbstractTransactionalDestinationFileActionStrategy;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class CopyFileActionStrategy
extends AbstractTransactionalDestinationFileActionStrategy {
    public CopyFileActionStrategy(String destinationDirectory, String tempDir, boolean sendContent) {
        super(destinationDirectory, tempDir, sendContent);
    }

    @Override
    protected void doInTransaction(FileTransaction tx, FileEvent changeEvent) throws TransactionException {
        try {
            Object dstPath = this.parseDestinationPath();
            String srcPath = changeEvent.getPath();
            File srcFile = new File(srcPath);
            if (srcFile.isDirectory()) {
                tx.copyFolder(srcPath, (String)dstPath);
            } else {
                if (FileUtil.endsWithFileSeparator((String)dstPath)) {
                    dstPath = (String)dstPath + FilenameUtils.getName(srcPath);
                }
                tx.copy(srcPath, (String)dstPath);
            }
        }
        catch (SecurityViolationException e) {
            e.printStackTrace();
        }
    }
}

