/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.file;

import com.streamscape.Trace;
import com.streamscape.lib.evfs.DirectoryMonitor;
import com.streamscape.lib.txfs.FileTransaction;
import com.streamscape.lib.txfs.exceptions.CommitException;
import com.streamscape.lib.txfs.exceptions.RollbackException;
import com.streamscape.lib.txfs.exceptions.TransactionException;
import com.streamscape.lib.txfs.mf.admin.FileResourceManagerFactory;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.enums.FileEventType;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.evtrigger.file.FileActionStrategy;
import java.io.File;
import java.util.Random;
import java.util.Set;

abstract class AbstractTransactionalFileActionStrategy
implements FileActionStrategy {
    protected String tempDirectory;
    protected FileEventType eventType;
    protected FileEvent fileChangeEvent;
    protected boolean success;
    protected boolean sendContent = false;
    protected String sourceFilePath = null;
    protected EventDatagramFactory datagramFactory = null;
    protected String errorMessage;
    protected MacroProcessor processor = new MacroProcessor();

    public AbstractTransactionalFileActionStrategy(String tempDir, boolean sendContent) {
        this.tempDirectory = tempDir + "/" + System.currentTimeMillis() + new Random().nextLong();
        this.sendContent = sendContent;
    }

    @Override
    public void setDatagramFactory(EventDatagramFactory factory) {
        this.datagramFactory = factory;
    }

    @Override
    public void setSourceFilePath(String path) {
        this.sourceFilePath = path;
    }

    @Override
    public boolean isSuccessed() {
        return this.success;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ImmutableEventDatagram action() throws FabricEventException {
        Trace.logDebug(this, "Performing actual file action...");
        this.success = false;
        if (this.fileChangeEvent == null) {
            throw new IllegalStateException("No event to process");
        }
        FileTransaction tx = null;
        try {
            tx = FileResourceManagerFactory.createTransaction("Transaction for " + this.fileChangeEvent.getName(), true);
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
        }
        try {
            ImmutableEventDatagram temp = null;
            if (this.sendContent) {
                temp = this.sendFileContent(this.fileChangeEvent.getAbsoluteFileName(), this.fileChangeEvent.getName());
            }
            this.doInTransaction(tx, this.fileChangeEvent);
            tx.commit(true);
            this.success = true;
            if (temp != null) {
                ImmutableEventDatagram immutableEventDatagram = temp;
                return immutableEventDatagram;
            }
        }
        catch (CommitException e) {
            Trace.logException(this, e, true);
            try {
                this.success = false;
                this.errorMessage = e.getMessage();
                tx.rollback();
            }
            catch (RollbackException e1) {
                Trace.logException(this, e1, true);
                Trace.logError(this, "Can neither commit nor rollback transation: " + tx.toString());
            }
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            this.success = false;
            this.errorMessage = error.getMessage();
        }
        finally {
            File tempDir = new File(this.tempDirectory);
            tempDir.delete();
        }
        Trace.logDebug(this, "Actual file action has been performed...");
        return this.fileChangeEvent;
    }

    protected abstract void doInTransaction(FileTransaction var1, FileEvent var2) throws TransactionException;

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    @Override
    public ImmutableEventDatagram invokeAction(ImmutableEventDatagram datagram) throws FabricEventException {
        block7: {
            this.fileChangeEvent = null;
            if (datagram != null) {
                this.processor.setEvent(datagram);
            }
            try {
                if (datagram != null && datagram instanceof FileEvent) {
                    this.fileChangeEvent = (FileEvent)datagram;
                    break block7;
                }
                if (this.sourceFilePath != null) {
                    FileEvent fileEvent = (FileEvent)this.datagramFactory.newEventInstance(FileEvent.class.getSimpleName());
                    fileEvent.init(new File(this.processor.process(this.sourceFilePath)), FileState.STATIC);
                    this.fileChangeEvent = fileEvent;
                    break block7;
                }
                System.out.println("Not applicable");
                return datagram;
            }
            catch (Exception e) {
                Trace.logException(this, e, true);
                throw new FabricEventException(e);
            }
        }
        try {
            return this.action();
        }
        catch (Exception e) {
            Trace.logException(this, e, true);
            throw new FabricEventException(e);
        }
    }

    protected ImmutableEventDatagram sendFileContent(String absoluteFileName, String name) {
        Trace.logDebug(this, "Sending '" + absoluteFileName + "' file content as event...");
        try {
            if (this.datagramFactory == null) {
                Trace.logError(AbstractTransactionalFileActionStrategy.class, "Unable to send file content because EventDatagramFactory is NULL.");
                return null;
            }
            BytesEvent fileContent = (BytesEvent)this.datagramFactory.createEvent("event.file.Content");
            fileContent.setBytes(FileIOUtils.getFileContent(new File(absoluteFileName)));
            fileContent.setEventGroupId(this.fileChangeEvent.getEventGroupId());
            fileContent.setCorrelationIdAsBytes(this.fileChangeEvent.getCorrelationIdAsBytes());
            fileContent.setEventKey(this.fileChangeEvent.getEventKey());
            this.initEventProperties(fileContent);
            Trace.logDebug(this, "File '" + absoluteFileName + "' converted into BytesEvent and prepared for send.");
            return fileContent;
        }
        catch (Exception exception) {
            Trace.logException(DirectoryMonitor.class, exception, true);
            return new ServiceFrameworkException(6002, exception.getMessage());
        }
    }

    protected void initEventProperties(BytesEvent fileContentEvent) {
        Set<String> propertyNames = this.fileChangeEvent.getEventPropertyNames();
        for (String propertyName : propertyNames) {
            try {
                fileContentEvent.setEventObjectProperty(propertyName, this.fileChangeEvent.getEventObjectProperty(propertyName));
            }
            catch (SDOException sDOException) {}
        }
    }
}

