/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.RowSetEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.evtrigger.AbstractEventTriggerAction;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.slex.slang.SLSession;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SlangQuery
extends AbstractEventTriggerAction {
    private EventDatagramFactory datagramFactory;
    private List<String> operations = new ArrayList<String>();
    private MacroProcessor processor;
    private static SLSession slSession = null;

    public SlangQuery() {
        this.supportsAdvisory = false;
        this.syntax = "<Slang Operation> [; <Slang Operation>;... ]";
        this.description = "Executes one or more SLANG operations and return RowSetEvent based on the last response.";
    }

    @Override
    public void init(FabricComponent component, EventTriggerDefinition trigger, String actionScript, RuntimeContext context) throws InvalidEventTriggerSyntaxException {
        super.init(component, trigger, actionScript, context);
        if (actionScript == null) {
            throw new InvalidEventTriggerSyntaxException("Action script is NULL.");
        }
        this.validateSyntax(actionScript);
        this.datagramFactory = context.getEventDatagramFactory();
        this.processor = new MacroProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkSLSession() throws FabricEventException {
        if (slSession != null) return;
        Class<AbstractEventTriggerAction> clazz = AbstractEventTriggerAction.class;
        synchronized (AbstractEventTriggerAction.class) {
            try {
                slSession = this.getConnection().createSLSession();
            }
            catch (Exception exception) {
                throw new FabricEventException("Creation of SLANG session failed.", (Throwable)exception);
            }
            return;
        }
    }

    @Override
    public ImmutableEventDatagram invokeAction(ImmutableEventDatagram event) throws FabricEventException {
        this.checkSLSession();
        this.processor.setEvent(event);
        try {
            RowSet rowSet = null;
            for (int i = 0; i < this.operations.size(); ++i) {
                String operation = this.processor.process(this.operations.get(i));
                Trace.logDebug(this, "Executing SLANG operation '" + operation + "'...");
                SLResponse slResponse = slSession.slangRequest(operation, 0L);
                if (!slResponse.isOK()) {
                    throw slResponse.getException() != null ? new FabricEventException(slResponse.getException()) : new FabricEventException(slResponse.getText());
                }
                if (i != this.operations.size() - 1) continue;
                if (slResponse.getRowSet() != null) {
                    rowSet = slResponse.getRowSet();
                    continue;
                }
                RowMetaData meta = new RowMetaData();
                meta.addColumn("Response", SQLType.STRING);
                rowSet = new RowSet(meta);
                if (slResponse.getText() != null) {
                    rowSet.addToRowSet(new Object[]{slResponse.getText()});
                    continue;
                }
                rowSet.addToRowSet(new Object[]{"OK"});
            }
            if (rowSet != null) {
                RowSetEvent result = (RowSetEvent)this.datagramFactory.newEventInstance("RowSetEvent");
                result.init(rowSet.getRowMetaData());
                for (int i = 1; i < rowSet.getRowCount() + 1; ++i) {
                    result.getRowSet().addToRowSet(rowSet.getRowAt(i).getRawData());
                }
                return result;
            }
        }
        catch (Exception exception) {
            if (exception instanceof FabricEventException) {
                throw (FabricEventException)exception;
            }
            throw new FabricEventException(exception);
        }
        return event;
    }

    @Override
    public void validateSyntax(String actionScript) throws InvalidEventTriggerSyntaxException {
        Trace.logDebug(this, "Initializing Slang Query event trigger action...");
        if (actionScript == null || actionScript.length() <= 0) {
            throw new InvalidEventTriggerSyntaxException("SlangQuery event trigger action requires action script. May not be NULL.");
        }
        StringTokenizer tokenizer = new StringTokenizer(actionScript, ";");
        while (tokenizer.hasMoreTokens()) {
            this.operations.add(tokenizer.nextToken().trim());
        }
        Trace.logDebug(this, "Slang Query event trigger action initialized.");
    }

    @Override
    public List<String> getOutboundPrototypeModelsConstraint() {
        ArrayList<String> constraint = new ArrayList<String>();
        constraint.add(RowSetEvent.class.getSimpleName());
        return constraint;
    }
}

