/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.omf.mapper.ConverterException;
import com.streamscape.omf.mapper.ConverterPlugin;
import com.streamscape.omf.mapper.ConverterPluginDescriptor;
import com.streamscape.omf.mapper.mf.ConverterPluginManager;
import com.streamscape.omf.mapper.mf.ConverterPluginManagerException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.evtrigger.AbstractEventTriggerAction;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MailPublisher
extends AbstractEventTriggerAction {
    String subject = null;
    String to = null;
    String cc = null;
    String body = null;
    String contentType = null;
    MacroProcessor processor = new MacroProcessor();
    ConverterPlugin converter = null;
    boolean converterReturnsEvent = false;
    private static final Pattern SYNTAX = Pattern.compile("(?i)(?:SEND\\s+MAIL)\\s+('([^']+)')?\\s*(?:TO\\s*:\\s*([^\\s]+))\\s*(?:CC\\s*:\\s*([^\\s]+))?\\s*(?:SUBJECT\\s*:\\s*'([^']+)')\\s*(?:CONVERT\\s+USING\\s+([^\\s]+))?\\s*(?:CONTENT\\s+TYPE\\s+'([^']+)')?");

    public MailPublisher() {
        this.syntax = "SEND MAIL [ '<MessageBody>' ] TO:<Recipient> [, Recipient ...] [ CC:<Recipient> [, Recipient ...] ]    SUBJECT:'<Message Subject>' [ CONVERT USING <Converter Plugin Name> ] [ CONTENT TYPE <Content Type>]";
        this.description = "A mail publisher raises Mail Events, allowing recipient lists, custom content and MIME types such text/plain as to be set.";
    }

    @Override
    public void init(FabricComponent component, EventTriggerDefinition trigger, String actionScript, RuntimeContext ctx) throws InvalidEventTriggerSyntaxException {
        super.init(component, trigger, actionScript, ctx);
        Matcher matcher = SYNTAX.matcher(actionScript);
        if (matcher.find()) {
            if (matcher.group(1) != null) {
                this.body = matcher.group(2);
            }
            this.to = matcher.group(3);
            if (matcher.group(4) != null) {
                this.cc = matcher.group(4);
            }
            if (matcher.group(5) != null) {
                this.subject = matcher.group(5);
            }
            if (matcher.group(6) != null) {
                ConverterPluginManager converterManager = RuntimeContext.getInstance().getConverterPluginManager();
                if (!converterManager.existsConverterPlugin(matcher.group(6))) {
                    throw new InvalidEventTriggerSyntaxException("Unknown converter plugin '" + matcher.group(6) + "' specified.");
                }
                try {
                    ConverterPluginDescriptor pluginDescriptor = converterManager.getConverterPluginDescriptor(matcher.group(6));
                    SemanticType type = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType(pluginDescriptor.getOutboundSemanticType());
                    if (type.getClassName().equals(MailEvent.class.getName())) {
                        this.converterReturnsEvent = true;
                    } else if (!type.getClassName().equals(MailEvent.class.getName())) {
                        throw new InvalidEventTriggerSyntaxException("Invalid converter plugin specified. Must return Mail Event or String.");
                    }
                    this.converter = converterManager.createConverterPlugin(matcher.group(6));
                }
                catch (ConverterPluginManagerException error) {
                    throw new InvalidEventTriggerSyntaxException("Unable to create converter plugin '" + matcher.group(6) + "'. " + error.getMessage());
                }
            }
            if (matcher.group(7) != null) {
                this.contentType = matcher.group(7);
            }
        } else {
            throw new InvalidEventTriggerSyntaxException("Invalid syntax '" + actionScript + "' specified.");
        }
        this.processor = new MacroProcessor();
    }

    @Override
    public ImmutableEventDatagram invokeAction(ImmutableEventDatagram datagram) {
        try {
            Object resultBody;
            this.processor.setEvent(datagram);
            MailEvent resultEvent = this.converter != null && this.converterReturnsEvent ? (MailEvent)this.converter.convert(datagram) : (MailEvent)EventDatagramFactory.getInstance().newEventInstance("MailEvent");
            resultEvent.setSubject(this.processor.process(this.subject));
            resultEvent.setTo(Arrays.asList(this.processor.process(this.to).split(",")));
            if (this.cc != null) {
                resultEvent.setCc(Arrays.asList(this.processor.process(this.cc).split(",")));
            }
            if (this.body != null) {
                resultEvent.setBody(this.processor.process(this.body));
            }
            if (this.converter != null && !this.converterReturnsEvent && (resultBody = this.converter.convert(datagram)) instanceof String) {
                resultEvent.setBody((String)resultBody);
            }
            if (this.contentType != null) {
                resultEvent.setContentType(this.contentType);
            }
            return resultEvent;
        }
        catch (DatagramFactoryException error) {
            throw new IllegalStateException("Unable to create Mail Event. " + error.getMessage());
        }
        catch (SecurityViolationException error) {
            throw new IllegalStateException("Unable to fill in Mail Event. " + error.getMessage());
        }
        catch (ConverterException error) {
            throw new IllegalStateException("Unable to initialize Mail Event. " + error.getMessage());
        }
    }

    @Override
    public List<String> getOutboundPrototypeModelsConstraint() {
        ArrayList<String> constraint = new ArrayList<String>();
        constraint.add(MailEvent.class.getSimpleName());
        return constraint;
    }

    @Override
    public void validateSyntax(String actionScript) throws InvalidEventTriggerSyntaxException {
        Matcher matcher = SYNTAX.matcher(actionScript);
        if (!matcher.find()) {
            throw new InvalidEventTriggerSyntaxException("Invalid syntax at '" + actionScript + "'.");
        }
    }

    public static void main(String[] args) {
        String syntax = "send mail '<html><p>New event received</p></html>' to:sergey@streamscape.com subject:'[Notification]' content type 'text/html'";
        syntax = "send mail to : sergey@streamscape.com cc : MessageSupport@blackstone.com subject : '[Non-Critical Error]' convert using BlackstoneSpResultToEmail";
        Matcher matcher = SYNTAX.matcher(syntax);
        if (matcher.find()) {
            System.out.println("Message: " + matcher.group(2));
            System.out.println("To: " + String.valueOf(Arrays.asList(matcher.group(3).split(","))));
            System.out.println("Cc: " + matcher.group(4));
            System.out.println("Subject: " + matcher.group(5));
            System.out.println("Converter: " + matcher.group(6));
            System.out.println("Content Type: " + matcher.group(7));
        } else {
            System.out.println("Does not match");
        }
    }
}

