/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.evtrigger.AbstractEventTriggerAction;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.file.FileActionStrategy;
import com.streamscape.sef.evtrigger.file.FileActionStrategyFactory;
import java.util.ArrayList;
import java.util.List;

public class FileAction
extends AbstractEventTriggerAction {
    private String actionScript;
    protected FileActionStrategy fileActionStrategy;

    public FileAction() {
        this.supportsAdvisory = false;
        this.syntax = "[ SEND AND ] { RENAME | COPY | DELETE | MOVE } '<Source File Name>' [ FILE ] \n  [ { AS '<Target File Name>' | TO '<Target Dir Name>' }]";
        this.description = "A trigger that takes a specified set of actions on a file represented by the inbound File Event.";
    }

    @Override
    public void init(FabricComponent component, EventTriggerDefinition trigger, String actionScript, RuntimeContext ctx) throws InvalidEventTriggerSyntaxException {
        Trace.logDebug(this, "Initializing FileAction...");
        if (actionScript == null) {
            throw new InvalidEventTriggerSyntaxException(FileAction.class.getSimpleName() + " trigger action requires action script. It can't be NULL.");
        }
        this.component = component;
        this.actionScript = actionScript;
        super.init(component, trigger, actionScript, ctx);
        this.fileActionStrategy = FileActionStrategyFactory.chooseStrategy(this.actionScript);
        this.fileActionStrategy.setDatagramFactory(ctx.getEventDatagramFactory());
        Trace.logDebug(this, "FileAction is initialized");
    }

    @Override
    public void validateSyntax(String actionScript) throws InvalidEventTriggerSyntaxException {
        FileActionStrategyFactory.validateSyntax(actionScript);
    }

    @Override
    public ImmutableEventDatagram invokeAction(ImmutableEventDatagram datagram) throws FabricEventException {
        Trace.logDebug(this, "Invoke action for " + datagram.getEventId());
        return this.fileActionStrategy.invokeAction(datagram);
    }

    @Override
    public List<String> getOutboundPrototypeModelsConstraint() {
        ArrayList<String> constraint = new ArrayList<String>();
        constraint.add(FileEvent.class.getSimpleName());
        constraint.add(BytesEvent.class.getSimpleName());
        return constraint;
    }

    @Override
    public AbstractEventTriggerAction clone() {
        return super.clone();
    }
}

