/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.TriggerActionTime;

public class EventTriggerDefinition {
    protected String triggerName = null;
    protected EventScope eventScope = EventScope.OBSERVABLE;
    protected String triggerEventSelector = null;
    protected String actionEventId = null;
    protected String eventHandlerName = null;
    protected boolean autoEnable = true;
    protected String actionableEventAlias = null;
    protected String sourceEventAlias = null;
    protected String triggerScript = null;
    protected String fullSyntax = null;

    public EventTriggerDefinition() {
    }

    protected EventTriggerDefinition(EventTriggerDefinition definition) {
        this.triggerName = definition.triggerName;
        this.eventScope = definition.eventScope;
        this.triggerEventSelector = definition.triggerEventSelector;
        this.actionEventId = definition.actionEventId;
        this.eventHandlerName = definition.eventHandlerName;
        this.autoEnable = definition.autoEnable;
        this.actionableEventAlias = definition.actionableEventAlias;
        this.sourceEventAlias = definition.sourceEventAlias;
        this.triggerScript = definition.triggerScript;
        this.fullSyntax = definition.fullSyntax;
    }

    public void setName(String triggerName) throws InvalidEventTriggerSyntaxException {
        if (!StringUtils.validateObjectName(triggerName)) {
            throw new InvalidEventTriggerSyntaxException("Invalid trigger name syntax '" + triggerName + "'.");
        }
        this.triggerName = triggerName;
    }

    public String getName() {
        return this.triggerName;
    }

    public void setEventScope(EventScope scope) {
        this.eventScope = scope;
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public String getEventSelector() {
        return this.triggerEventSelector;
    }

    public void setEventSelector(String selector) throws SelectorFormatException {
        this.triggerEventSelector = selector;
    }

    public boolean hasEventSelector() {
        return this.triggerEventSelector != null;
    }

    public void setActionableEventId(String eventId) throws SDOFormatException {
        if (this.eventHandlerName != null && this.eventHandlerName.length() > 0) {
            throw new SDOFormatException("Actionable EventId cannot be set for BEFORE event trigger which already has Event Handler name defined. ");
        }
        SDOUtils.validateEventId(eventId);
        this.actionEventId = eventId;
    }

    public String getActionableEventId() {
        return this.actionEventId;
    }

    public void setAutoEnable(boolean autoEnable) {
        this.autoEnable = autoEnable;
    }

    public boolean isAutoEnable() {
        return this.autoEnable;
    }

    public TriggerActionTime getTriggerActionTime() {
        if (this.eventHandlerName != null && this.eventHandlerName.length() > 0) {
            return TriggerActionTime.BEFORE;
        }
        return TriggerActionTime.AFTER;
    }

    public void setEventHandlerName(String name) throws InvalidEventTriggerSyntaxException {
        if (!StringUtils.validateObjectName(name)) {
            throw new InvalidEventTriggerSyntaxException("Invalid Event Handler name syntax '" + name + "'.");
        }
        if (this.actionEventId != null && this.actionEventId.length() > 0) {
            throw new InvalidEventTriggerSyntaxException("Event Handler name cannot be set for AFTER event trigger which  already has actionable EventId defined. ");
        }
        this.eventHandlerName = name;
    }

    public String getEventHandlerName() {
        return this.eventHandlerName;
    }

    public boolean hasTriggerScript() {
        return this.triggerScript != null && this.triggerScript.length() > 0;
    }

    public void setTriggerScript(String triggerScript) {
        this.triggerScript = triggerScript;
    }

    public String getTriggerScript() {
        return this.triggerScript;
    }

    public void setFullSyntax(String fullSyntax) {
        this.fullSyntax = fullSyntax;
    }

    public String getFullSyntax() {
        if (this.fullSyntax != null) {
            return this.fullSyntax;
        }
        return this.toString();
    }

    public String getActionableEventAlias() {
        return this.actionableEventAlias;
    }

    public void setActionableEventAlias(String actionableEventAlias) {
        this.actionableEventAlias = actionableEventAlias;
    }

    public String getSourceEventAlias() {
        return this.sourceEventAlias;
    }

    public void setSourceEventAlias(String sourceEventAlias) {
        this.sourceEventAlias = sourceEventAlias;
    }

    public String toString() {
        if (this.fullSyntax != null) {
            return this.fullSyntax;
        }
        return "CREATE EVENT TRIGGER " + this.triggerName + "\n" + (String)(this.eventScope != null ? " EVENT SCOPE " + String.valueOf((Object)this.eventScope) + "\n" : "") + (this.getTriggerActionTime() == TriggerActionTime.BEFORE ? " BEFORE EVENT HANDLER " + this.eventHandlerName + "\n" : " AFTER EVENT [" + this.actionEventId + "]\n") + (String)(this.getSourceEventAlias() != null ? " SOURCE EVENT AS " + this.getSourceEventAlias() + "\n" : "") + (String)(this.getActionableEventAlias() != null ? " ACTIONABLE EVENT AS " + this.getActionableEventAlias() + "\n" : "") + (String)(this.hasEventSelector() ? " WHEN (" + this.getEventSelector() + ")\n" : "") + "as\n" + this.getTriggerScript() + "\n";
    }
}

