/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricManagedComponent;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.evtrigger.AbstractEventTriggerAction;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventLogger
extends AbstractEventTriggerAction {
    protected String header = null;
    protected List<Object> headerChunks = new ArrayList<Object>();
    protected boolean hasHeader = false;
    protected boolean withContent = false;
    protected MacroProcessor processor = null;
    protected TextSerializer serializer = null;
    private static final Pattern LOG_EVENT_SYNTAX = Pattern.compile("(?i)^(?:LOG\\s+EVENT)\\s*(?:HEADER\\s+'([^']+)')?\\s*(?:WITH\\s+CONTENT\\s*(?:AS\\s+([^\\s]+))?)?$");

    public EventLogger() {
        this.syntax = "LOG EVENT [ HEADER 'Header Text'] [ WITH CONTENT [ AS { XML | JSON } ] ]";
        this.description = "An event logging trigger that allows users to write Actionable Events to the error log.";
    }

    @Override
    public void init(FabricComponent component, EventTriggerDefinition trigger, String actionScript, RuntimeContext ctx) throws InvalidEventTriggerSyntaxException {
        super.init(component, trigger, actionScript, ctx);
        if (actionScript == null) {
            throw new InvalidEventTriggerSyntaxException(EventLogger.class.getSimpleName() + " trigger action requies action script. It can't be NULL.");
        }
        this.validateSyntax(actionScript);
        boolean isJson = false;
        Matcher matcher = LOG_EVENT_SYNTAX.matcher(actionScript.trim());
        if (matcher.find()) {
            if (matcher.group(1) != null) {
                this.header = matcher.group(1);
                this.hasHeader = true;
            }
            if (matcher.group(2) != null) {
                this.withContent = true;
                String format = matcher.group(2);
                if (format.equalsIgnoreCase("json")) {
                    isJson = true;
                }
            }
            try {
                if (isJson) {
                    this.serializer = HTTPUtils.getJsonSerializerForRest().withPrettyPrint(true);
                } else {
                    XSerializerFactory factory = this.context.getXSerializerFactory();
                    XSerializer xSerializer = factory.createSerializer("EventLoggerSerializer");
                    xSerializer.mapAttribute("SemanticType", "class");
                    this.serializer = xSerializer;
                }
            }
            catch (Exception error) {
                throw new InvalidEventTriggerSyntaxException("Unable to init serializer for event logger. " + error.getMessage());
            }
            this.processor = new MacroProcessor();
        } else {
            Trace.logError(this, "Failed to parse log event trigger action script.");
        }
    }

    @Override
    public ImmutableEventDatagram invokeAction(ImmutableEventDatagram datagram) {
        try {
            Logger logger;
            String eventContent;
            String resultHeader;
            this.processor.setEvent(datagram);
            if (!(this.component instanceof FabricManagedComponent)) {
                throw new RuntimeException("Unable to log event as can't get valid service context.");
            }
            FabricManagedComponent managedComponent = (FabricManagedComponent)((Object)this.component);
            StringBuilder buffer = new StringBuilder();
            buffer.append('[');
            buffer.append(this.trigger.getName());
            buffer.append(']');
            if (this.hasHeader && (resultHeader = this.processor.process(this.header)) != null) {
                buffer.append(' ');
                buffer.append(resultHeader);
            }
            if (this.withContent && (eventContent = this.serializer.serialize(datagram)) != null) {
                buffer.append('\n');
                buffer.append(eventContent);
            }
            if ((logger = managedComponent.getLogger()) != null) {
                logger.logInfo(buffer.toString());
            } else {
                Trace.logError(this, "Unable to get logger from the host component. Writing to the trace...\n" + buffer.toString());
            }
            return datagram;
        }
        catch (IAbstractExceptionEvent ex) {
            throw new RuntimeException("Trigger action 'EventLogger' Data Exception: " + ex.getMessage());
        }
    }

    @Override
    public void validateSyntax(String actionScript) throws InvalidEventTriggerSyntaxException {
        Matcher matcher = LOG_EVENT_SYNTAX.matcher(actionScript.trim());
        if (!matcher.find()) {
            throw new InvalidEventTriggerSyntaxException("Incorrect event logger trigger action syntax '" + actionScript + "'.");
        }
    }
}

