/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.TypeNamingException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.evtrigger.AbstractEventTriggerAction;
import com.streamscape.sef.evtrigger.AuditEventBuilder;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import java.util.ArrayList;
import java.util.List;

public class Auditor
extends AbstractEventTriggerAction {
    protected transient AuditEventBuilder builder = null;

    public Auditor() {
        this.supportsAdvisory = false;
        this.syntax = "AUDIT MESSAGE 'Message Text' \n  [ LEVEL { SEVERE | WARNING | INFO | GENERIC } ] \n    [ AuditEvent.<Property> = '<Value>' ] ";
        this.description = "A trigger that publishes an Audit Event as a Text with Severity and optional Properties.";
        try {
            this.prototype = new Prototype("AuditEvent", "AuditEvent");
        }
        catch (TypeNamingException ex) {
            throw new RuntimeException("Auditor Trigger Action creation error: " + ex.getMessage());
        }
    }

    @Override
    public void init(FabricComponent component, EventTriggerDefinition trigger, String actionScript, RuntimeContext ctx) throws InvalidEventTriggerSyntaxException {
        super.init(component, trigger, actionScript, ctx);
        if (actionScript == null) {
            throw new InvalidEventTriggerSyntaxException(Auditor.class.getSimpleName() + " trigger action requies action script. May not be NULL.");
        }
        this.validateSyntax(actionScript);
        this.builder = new AuditEventBuilder(ctx);
        this.builder.parse(actionScript);
    }

    @Override
    public ImmutableEventDatagram invokeAction(ImmutableEventDatagram datagram) {
        try {
            return this.builder.buildAuditEvent(datagram);
        }
        catch (SecurityViolationException ex) {
            throw new RuntimeException("Trigger action 'Auditor' Data Exception: " + ex.getMessage());
        }
        catch (DatagramFactoryException ex) {
            throw new RuntimeException("Trigger action 'Auditor' Data Exception: " + ex.getMessage());
        }
        catch (SDOException ex) {
            throw new RuntimeException("Trigger action 'Auditor' Data Exception: " + ex.getMessage());
        }
    }

    @Override
    public List<String> getOutboundPrototypeModelsConstraint() {
        ArrayList<String> constraint = new ArrayList<String>();
        constraint.add(AuditEvent.class.getSimpleName());
        return constraint;
    }

    @Override
    public void validateSyntax(String actionScript) throws InvalidEventTriggerSyntaxException {
        if (!AuditEventBuilder.isValidSyntax(actionScript)) {
            throw new InvalidEventTriggerSyntaxException("Invalid syntax at '" + actionScript + "'.");
        }
    }
}

