/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AuditEventBuilder {
    private static final Pattern AUDIT_MESSAGE_SYNTAX = Pattern.compile("(?i)^(?:AUDIT\\s+MESSAGE)\\s+'([^']+)'\\s*(?:LEVEL\\s+([^\\s]+))?\\s*((AuditEvent\\.\\w+\\s*=\\s*.+,?)+)?$");
    protected HashMap<String, String> userProperties = new HashMap();
    String message = "";
    Severity severity = Severity.GENERIC;
    String auditEventId = "event.audit";
    MacroProcessor processor = new MacroProcessor();
    protected EventDatagramFactory factory = null;
    protected RuntimeContext ctx = null;

    AuditEventBuilder(RuntimeContext ctx) {
        this.ctx = ctx;
        this.factory = ctx.getEventDatagramFactory();
    }

    AuditEventBuilder() {
    }

    public void parse(String auditScript) throws InvalidEventTriggerSyntaxException {
        int start = auditScript.indexOf(39);
        int end = auditScript.indexOf(39, start + 1);
        boolean messageFound = false;
        String rest = null;
        StringBuilder buffer = new StringBuilder();
        while (!messageFound && end > 0) {
            int pos = auditScript.indexOf(39, end + 1);
            if (pos != end + 1) {
                messageFound = true;
                buffer.append(auditScript.substring(start + 1, end));
                continue;
            }
            buffer.append(auditScript.substring(start + 1, end)).append('\'');
            start = pos + 1;
            end = auditScript.indexOf(39, pos + 1);
        }
        if (end == -1) {
            throw new InvalidEventTriggerSyntaxException("Incorrect syntax of the audit message.");
        }
        this.message = buffer.toString();
        rest = auditScript.substring(end + 1).trim();
        if (rest.startsWith("level") || rest.startsWith("LEVEL")) {
            start = rest.indexOf(32);
            end = rest.indexOf(32, start + 1);
            while (end == end + 1) {
            }
            if (end == -1) {
                end = rest.length();
            }
            String severityValue = rest.substring(start, end).trim();
            try {
                this.severity = Severity.valueOf(severityValue);
            }
            catch (IllegalArgumentException error) {
                Trace.logError(this, "Specified severity '" + severityValue + "' is incorrect. GENERIC is used.");
            }
        }
        if (end != -1 && end < rest.length()) {
            this.extractUserProperties(rest.substring(end + 1).trim());
        }
    }

    public void setAuditEventId(String eventId) {
        this.auditEventId = eventId;
    }

    public void extractUserProperties(String propertiesString) {
        int pos = 0;
        while ((pos = propertiesString.indexOf("AuditEvent")) != -1) {
            int end = propertiesString.indexOf("AuditEvent", pos + 1);
            if (end == -1) {
                end = propertiesString.length();
            }
            String token = propertiesString.substring(propertiesString.indexOf(".", pos) + 1, end);
            int temp = token.indexOf(61);
            String propName = token.substring(0, temp).trim();
            int lastComma = token.lastIndexOf(44);
            String value = null;
            value = lastComma != -1 ? token.substring(temp + 1, lastComma).trim() : token.substring(temp + 1).trim();
            if (value.charAt(0) == '\'') {
                this.userProperties.put(propName, value.substring(1, value.length() - 1));
            } else {
                this.userProperties.put(propName, value);
            }
            propertiesString = propertiesString.substring(end).trim();
        }
    }

    public AuditEvent buildAuditEvent(ImmutableEventDatagram event) throws DatagramFactoryException, SecurityViolationException, SDOException {
        AuditEvent result = (AuditEvent)this.factory.createEvent(this.auditEventId);
        this.processor.setEvent(event);
        result.setAuditData(this.processor.process(this.message));
        result.setSeverity(this.severity);
        if (event instanceof EventDatagram) {
            EventDatagram sourceEvent = (EventDatagram)event;
            result.setEventGroupId(sourceEvent.getEventGroupId());
            result.setCorrelationIdAsBytes(sourceEvent.getCorrelationIdAsBytes());
            result.setEventKey(sourceEvent.getEventKey());
            this.initAuditEventProperties(sourceEvent, result);
        } else if (event instanceof ExceptionEventDatagram) {
            ExceptionEventDatagram sourceException = (ExceptionEventDatagram)event;
            result.setEventGroupId(sourceException.getEventGroupId());
            result.setCorrelationIdAsBytes(sourceException.getCorrelationIdAsBytes());
            result.setEventKey(sourceException.getEventKey());
        }
        return result;
    }

    private void initAuditEventProperties(EventDatagram source, EventDatagram target) throws SDOException {
        for (Map.Entry<String, String> entry : this.userProperties.entrySet()) {
            target.setEventObjectProperty(entry.getKey(), this.processor.process(entry.getValue()));
        }
    }

    public static boolean isValidSyntax(String syntax) {
        Matcher matcher = AUDIT_MESSAGE_SYNTAX.matcher(syntax.trim());
        return matcher.find();
    }
}

