/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.evtrigger.AbstractEventTriggerAction;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Acknowledge
extends AbstractEventTriggerAction {
    protected EventDatagramFactory datagramFactory = null;
    protected String action = null;
    protected MacroProcessor processor = null;
    private static final Pattern ACKNOWLEDGER_SYNTAX = Pattern.compile("(?i)^(?:AcknowledgeEvent\\.onAcknowledgeAction)\\s*=\\s*(\\w+)$");

    public Acknowledge() {
        this.supportsAdvisory = false;
        this.syntax = "AcknowledgeEvent.onAcknowledgeAction = \n   { ACKNOWLEDGE | ACKNOWLEDGE_AND_FORWARD | ACKNOWLEDGE_AND_DISCARD | ACKNOWLEDGE_AND_EXPIRE | ACKNOWLEDGE_UNDELIVERED | ACKNOWLEDGE_AND_SUSPEND | RESCIND | RESCIND_AND_FORWARD | RESCIND_AND_DISCARD } \n [, AcknowledgeEvent.recipientId = <value> ] \n [, AcknowledgeEvent.correlationEventExpiration = <value> ] \n [, AcknowledgeEvent.correlationTimeStamp = <value> ] \n [, AcknowledgeEvent.correlationEventSource = <value> ] \n [, AcknowledgeEvent.correlationEventId = <value> ] \n [, AcknowledgeEvent.<property> = <propertyValue>, ...]";
        this.description = "A trigger that acknowledges Actionable Events by specific action.";
    }

    @Override
    public void init(FabricComponent component, EventTriggerDefinition trigger, String actionScript, RuntimeContext ctx) throws InvalidEventTriggerSyntaxException {
        super.init(component, trigger, actionScript, ctx);
        if (actionScript == null) {
            throw new InvalidEventTriggerSyntaxException("Action script is NULL.");
        }
        this.validateSyntax(actionScript);
        this.datagramFactory = ctx.getEventDatagramFactory();
        this.processor = new MacroProcessor();
    }

    @Override
    public ImmutableEventDatagram invokeAction(ImmutableEventDatagram event) throws FabricEventException {
        AcknowledgeAction ackAction;
        this.processor.setEvent(event);
        try {
            ackAction = AcknowledgeAction.valueOf(this.processor.process(this.action));
        }
        catch (IllegalArgumentException error) {
            throw new FabricEventException("Illegal acknowledge action '" + this.processor.process(this.action) + "'. Unable to raise acknowledgement.");
        }
        try {
            AcknowledgementEvent result = event instanceof EventDatagram ? this.datagramFactory.createAcknowledgement((EventDatagram)event, true) : this.datagramFactory.createAcknowledgement((ExceptionEventDatagram)event);
            result.setAction(ackAction);
            return result;
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            throw new FabricEventException(error.getMessage());
        }
    }

    @Override
    public void validateSyntax(String actionScript) throws InvalidEventTriggerSyntaxException {
        Trace.logDebug(this, "Acknowledge trigger event action initializing...");
        if (actionScript == null || actionScript.length() <= 0) {
            throw new InvalidEventTriggerSyntaxException(Acknowledge.class.getSimpleName() + " trigger action requies action script. May not be NULL.");
        }
        Matcher matcher = ACKNOWLEDGER_SYNTAX.matcher(actionScript.trim());
        if (!matcher.find()) {
            throw new InvalidEventTriggerSyntaxException("Invalid syntax at '" + actionScript + "'. Acknowledge action set to default: ACKNOWLEDGE.");
        }
        this.action = matcher.group(1);
        Trace.logDebug(this, "Acknowledge trigger event action initialized. Acknowledge action: " + this.action);
    }
}

