/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger;

import com.streamscape.Trace;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.InvalidActionScriptSyntaxException;
import com.streamscape.sef.InvalidEventTriggerSyntaxException;
import com.streamscape.sef.dispatcher.EventTriggerActionHelper;
import com.streamscape.sef.evtrigger.EventTriggerAction;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

abstract class AbstractEventTriggerAction
extends EventTriggerActionHelper
implements EventTriggerAction {
    protected String name = this.getClass().getSimpleName();
    protected String syntax = "";
    protected Prototype prototype = null;
    protected String description = null;
    protected boolean supportsAdvisory = true;
    protected boolean supportsEvent = true;
    protected transient HashMap<String, Object> eventProperties = new HashMap();
    protected transient FabricComponent component = null;
    protected transient EventTriggerDefinition trigger = null;
    protected transient HashMap<String, Object> syntaxChunks = null;

    public AbstractEventTriggerAction() {
        Trace.logDebug(this, "Event Trigger Action '" + this.name + "' created.");
    }

    @Override
    public boolean supportsAdvisory() {
        return this.supportsAdvisory;
    }

    @Override
    public boolean supportsEvent() {
        return this.supportsEvent;
    }

    protected Object getScriptProperty(String propertyName) {
        return this.eventProperties.get(propertyName);
    }

    protected void setScriptProperty(String propertyName, Object value) {
        this.eventProperties.put(propertyName, value);
    }

    protected boolean hasScriptProperty(String propertyName) {
        return this.eventProperties.containsKey(propertyName);
    }

    protected void initEventProperties(ImmutableEventDatagram datagram) throws SDOException {
        this.setScriptProperty("eventId", datagram.getEventId());
        this.setScriptProperty("eventSource", datagram.getEventSource());
        this.setScriptProperty("durable", datagram.getDurable());
        this.setScriptProperty("timestamp", datagram.getTimestamp());
        if (datagram instanceof EventDatagram) {
            for (String propertyName : this.eventProperties.keySet()) {
                Object obj = ((EventDatagram)datagram).getEventObjectProperty(propertyName);
                if (obj == null) continue;
                this.eventProperties.put(propertyName, obj);
            }
            if (((EventDatagram)datagram).getCorrelationId() != null) {
                this.setScriptProperty("correlationId", ((EventDatagram)datagram).getCorrelationId());
            } else {
                this.setScriptProperty("correlationId", "");
            }
            if (((EventDatagram)datagram).getEventKey() != null) {
                this.setScriptProperty("eventKey", ((EventDatagram)datagram).getEventKey());
            } else {
                this.setScriptProperty("eventKey", "");
            }
            if (((EventDatagram)datagram).getEventGroupId() != null) {
                this.setScriptProperty("eventGroupId", ((EventDatagram)datagram).getEventGroupId());
            } else {
                this.setScriptProperty("eventGroupId", "");
            }
            if (((EventDatagram)datagram).getForwardTo() != null) {
                this.setScriptProperty("forwardTo", ((EventDatagram)datagram).getForwardTo());
            } else {
                this.setScriptProperty("forwardTo", "");
            }
            if (((EventDatagram)datagram).getReplyTo() != null) {
                this.setScriptProperty("replyTo", ((EventDatagram)datagram).getReplyTo());
            } else {
                this.setScriptProperty("replyTo", "");
            }
        }
    }

    @Override
    public void init(FabricComponent component, EventTriggerDefinition trigger, String actionScript, RuntimeContext context) throws InvalidEventTriggerSyntaxException {
        this.component = component;
        this.trigger = trigger;
        this.context = context;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setSyntax(String actionSyntax) throws InvalidActionScriptSyntaxException {
        if (actionSyntax.startsWith("{") || actionSyntax.endsWith("}")) {
            throw new InvalidActionScriptSyntaxException("Invalid use of brackets in script syntax.");
        }
        this.syntax = actionSyntax;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSyntax() {
        if (this.trigger != null) {
            String actionSyntax = this.syntax.length() == 0 ? "" : "{\n      {\n" + this.syntax + "\n      }\n}";
            return "CREATE EVENT TRIGGER {Trigger Name} TYPE {TYPE} FOR {Qualified Component Name}\n AS   EVENT SCOPE {LOCAL | OBSERVABLE | GLOBAL}\n  EVENT GROUP {Distinct Group Name}\n  (AFTER EVENT {Distinct Actionable Event Name} | BEFORE {Event Handler Name}) \n    [WHEN ({Event Selector Clause})]\n    [ACTION (\n" + actionSyntax + "    )]\n  [RAISE ADVISORY]  [RAISE EVENT] [ON {Distinct Event Id}]\n;";
        }
        return this.syntax;
    }

    @Override
    public List<String> getInboundPrototypeModelsConstraint() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getOutboundPrototypeModelsConstraint() {
        return new ArrayList<String>();
    }

    @Override
    public AbstractEventTriggerAction clone() {
        return (AbstractEventTriggerAction)super.clone();
    }
}

