/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.sdo;

import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.network.http.server.authentication.runtime.TokenGenerator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DropBoxSharedResources {
    public static final String DROPBOX_SHARE_RESOURCE_PREFIX_URL = "/dropbox/share/";
    private Map<String, DropBoxSharedResource> resourcesMap = new HashMap<String, DropBoxSharedResource>();
    private transient Map<String, List<String>> resourcePathToResourceIdsMap = null;

    public synchronized DropBoxSharedResource createResource(String path, String resourceId, Long expiresAt, String username, DropBoxSharedResource.ShareMethod shareMethod) {
        if (resourceId == null) {
            resourceId = TokenGenerator.generateUtil("", 0);
        }
        DropBoxSharedResource resource = new DropBoxSharedResource(path, resourceId, expiresAt, username, shareMethod);
        this.resourcesMap.put(resource.getResourceId(), resource);
        return resource;
    }

    public synchronized DropBoxSharedResource getResourceById(String resourceId) {
        return this.resourcesMap.get(resourceId);
    }

    public synchronized List<DropBoxSharedResource> getResources() {
        ArrayList<DropBoxSharedResource> resources = new ArrayList<DropBoxSharedResource>(this.resourcesMap.values());
        resources.sort(Comparator.comparingLong(DropBoxSharedResource::getCreatedAt));
        return resources;
    }

    public void removeResource(String resourceId) {
        this.resourcesMap.remove(resourceId);
    }

    public synchronized List<String> getResourceIdsByPath(String path) {
        if (this.resourcePathToResourceIdsMap == null) {
            this.resourcePathToResourceIdsMap = new HashMap<String, List<String>>();
            this.resourcesMap.entrySet().forEach(e -> {
                String resourcePath = ((DropBoxSharedResource)e.getValue()).getPath();
                if (!this.resourcePathToResourceIdsMap.containsKey(resourcePath)) {
                    this.resourcePathToResourceIdsMap.put(resourcePath, new ArrayList());
                }
                this.resourcePathToResourceIdsMap.get(resourcePath).add((String)e.getKey());
            });
        }
        path = DropBoxUtils.buildFolderShortcut(DropBoxUtils.normalizePath(path));
        return this.resourcePathToResourceIdsMap.getOrDefault(path, new ArrayList());
    }

    public DropBoxSharedResources clone() {
        DropBoxSharedResources result = new DropBoxSharedResources();
        result.resourcesMap = this.resourcesMap != null ? new HashMap<String, DropBoxSharedResource>(this.resourcesMap) : new HashMap();
        return result;
    }

    public static String buildSharedResourceUrl(String dropBoxName, DropBoxSharedResource resource) {
        return DROPBOX_SHARE_RESOURCE_PREFIX_URL + dropBoxName + "/" + resource.getResourceId();
    }

    public static class DropBoxSharedResource {
        private String path;
        private String resourceId;
        private long expiresAt;
        private String username;
        private final long createdAt;
        private ShareMethod shareMethod;

        public DropBoxSharedResource(String path, String resourceId, long expiresAt, String username, ShareMethod shareMethod) {
            this.path = path;
            this.resourceId = resourceId;
            this.expiresAt = expiresAt;
            this.username = username;
            this.shareMethod = shareMethod;
            this.createdAt = System.currentTimeMillis();
        }

        public String getPath() {
            return this.path;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }

        public boolean isExpired() {
            return this.expiresAt != 0L && this.expiresAt < System.currentTimeMillis();
        }

        public String getUsername() {
            return this.username;
        }

        public long getCreatedAt() {
            return this.createdAt;
        }

        public ShareMethod getShareMethod() {
            if (this.shareMethod == null) {
                this.shareMethod = ShareMethod.SHARED;
            }
            return this.shareMethod;
        }

        public static enum ShareMethod {
            PUBLIC,
            SHARED;

        }
    }
}

