/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.sdo;

import com.streamscape.sdo.CloneableObject;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBoxACLContext;
import com.streamscape.sef.network.http.server.dropbox.FolderType;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.parameter.TimeUnitParameter;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;

public class DropBoxFolder
implements CloneableObject {
    private String name;
    private String path;
    private FolderType type;
    private long fileSizeLimit = -1L;
    private SizeUnit fileSizeLimitUnit = SizeUnit.BYTES;
    private long folderSizeLimit = -1L;
    private SizeUnit folderSizeLimitUnit = SizeUnit.BYTES;
    private long expiration = -1L;
    private TimeUnit expirationUnit = TimeUnit.MILLISECONDS;
    private DropBoxACLContext aclFolderContext = new DropBoxACLContext();

    public DropBoxFolder() {
    }

    public DropBoxFolder(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public DropBoxFolder setName(String name) {
        this.name = name;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = DropBoxUtils.normalizePath(path);
    }

    public FolderType getType() {
        return this.type;
    }

    public void setType(FolderType type) {
        this.type = type;
    }

    public long getFileSizeLimit() {
        return this.fileSizeLimit;
    }

    public long getFileSizeLimitInBytes() {
        return this.fileSizeLimit > 0L && this.fileSizeLimitUnit != null ? this.fileSizeLimitUnit.toBytes(this.fileSizeLimit) : this.fileSizeLimit;
    }

    public String getFileSizeLimitString() {
        return this.fileSizeLimit > 0L && this.fileSizeLimitUnit != null ? this.fileSizeLimit + " " + this.fileSizeLimitUnit.getName() : (this.fileSizeLimit > 0L ? SizeUnit.convertToBestFractional(this.fileSizeLimit, SizeUnit.BYTES).toStringWithPrecision(2) : "unlimited");
    }

    public String getFolderSizeLimitString() {
        return this.folderSizeLimit > 0L && this.folderSizeLimitUnit != null ? this.folderSizeLimit + " " + this.folderSizeLimitUnit.getName() : (this.folderSizeLimit > 0L ? SizeUnit.convertToBestFractional(this.folderSizeLimit, SizeUnit.BYTES).toStringWithPrecision(2) : "unlimited");
    }

    public void setFileSizeLimit(long fileSizeLimit) {
        this.fileSizeLimit = fileSizeLimit;
    }

    public SizeUnit getFileSizeLimitUnit() {
        return this.fileSizeLimitUnit;
    }

    public void setFileSizeLimitUnit(SizeUnit fileSizeLimitUnit) {
        this.fileSizeLimitUnit = fileSizeLimitUnit;
    }

    public long getFolderSizeLimit() {
        return this.folderSizeLimit;
    }

    public void setFolderSizeLimit(long folderSizeLimit) {
        this.folderSizeLimit = folderSizeLimit;
    }

    public SizeUnit getFolderSizeLimitUnit() {
        return this.folderSizeLimitUnit;
    }

    public void setFolderSizeLimitUnit(SizeUnit folderSizeLimitUnit) {
        this.folderSizeLimitUnit = folderSizeLimitUnit;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public long getExpirationMillis() {
        return this.expiration >= 0L && this.expirationUnit != null ? this.expirationUnit.toMillis(this.expiration) : this.expiration;
    }

    public String getExpirationString() {
        return this.expiration > 0L && this.expirationUnit != null ? this.expiration + " " + TimeUnitParameter.getName(this.expirationUnit) : (this.expiration > 0L ? this.expiration + " ms" : "n/a");
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public TimeUnit getExpirationUnit() {
        return this.expirationUnit;
    }

    public void setExpirationUnit(TimeUnit expirationUnit) {
        this.expirationUnit = expirationUnit;
    }

    public boolean equalsPath(String path) {
        return Paths.get(DropBoxUtils.normalizePath(this.path), new String[0]).equals(Paths.get(DropBoxUtils.normalizePath(path), new String[0]));
    }

    public boolean isParentOf(String path) {
        if ((this.path == null || this.path.length() == 0) && !this.equalsPath(path) || this.path.equals(".") && !this.equalsPath(path)) {
            return true;
        }
        return Paths.get(DropBoxUtils.normalizePath(path), new String[0]).startsWith(Paths.get(DropBoxUtils.normalizePath(this.path), new String[0])) && !this.equalsPath(path);
    }

    public boolean isChildOf(String path) {
        return Paths.get(DropBoxUtils.normalizePath(this.path), new String[0]).startsWith(Paths.get(DropBoxUtils.normalizePath(path), new String[0])) && !this.equalsPath(path);
    }

    public DropBoxACLContext getAclFolderContext() {
        if (this.aclFolderContext == null) {
            this.aclFolderContext = new DropBoxACLContext();
        }
        return this.aclFolderContext.clone();
    }

    public DropBoxFolder setAclFolderContext(DropBoxACLContext aclFolderContext) {
        this.aclFolderContext = aclFolderContext;
        return this;
    }

    public String toString() {
        return "DropBoxFolder{path='" + this.path + "', type=" + String.valueOf((Object)this.type) + ", fileSizeLimit=" + this.fileSizeLimit + ", fileSizeLimitUnit=" + String.valueOf((Object)this.fileSizeLimitUnit) + ", folderSizeLimit=" + this.folderSizeLimit + ", folderSizeLimitUnit=" + String.valueOf((Object)this.folderSizeLimitUnit) + ", expiration=" + this.expiration + ", expirationUnit=" + String.valueOf((Object)this.expirationUnit) + "}";
    }

    @Override
    public DropBoxFolder clone() {
        DropBoxFolder result = new DropBoxFolder();
        result.name = this.name;
        result.path = this.path;
        result.type = this.type;
        result.fileSizeLimit = this.fileSizeLimit;
        result.fileSizeLimitUnit = this.fileSizeLimitUnit;
        result.folderSizeLimit = this.folderSizeLimit;
        result.folderSizeLimitUnit = this.folderSizeLimitUnit;
        result.expiration = this.expiration;
        result.expirationUnit = this.expirationUnit;
        result.aclFolderContext = this.aclFolderContext != null ? this.aclFolderContext.clone() : new DropBoxACLContext();
        return result;
    }
}

