/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.sdo;

import com.streamscape.sdo.CloneableObject;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DropBoxACL
implements CloneableObject {
    public static final Set<DropBoxAccessControlOperation> NONE_EXTENDED = Collections.unmodifiableSet(new HashSet<DropBoxAccessControlOperation>(Arrays.asList(DropBoxAccessControlOperation.NONE)));
    public static final Set<DropBoxAccessControlOperation> FULL_EXTENDED = Collections.unmodifiableSet(new HashSet(Arrays.stream(DropBoxAccessControlOperation.values()).filter(v -> v != DropBoxAccessControlOperation.NONE).collect(Collectors.toList())));
    public static final Set<DropBoxAccessControlOperation> PUBLIC_EXTENDED = Collections.unmodifiableSet(new HashSet<DropBoxAccessControlOperation>(Arrays.asList(DropBoxAccessControlOperation.PUBLIC)));
    private final Set<DropBoxAccessControlOperation> operations = new HashSet<DropBoxAccessControlOperation>();
    private transient Set<DropBoxAccessControlOperation> operationsExtended = new HashSet<DropBoxAccessControlOperation>();

    public DropBoxACL() {
    }

    public DropBoxACL(DropBoxAccessControlOperation ... operations) {
        this.addOperations(new HashSet<DropBoxAccessControlOperation>(Arrays.asList(operations)));
    }

    public DropBoxACL(Set<DropBoxAccessControlOperation> operations) {
        this.addOperations(operations);
    }

    public boolean isAllowed(DropBoxAccessControlOperation operation) {
        this.initOperationsExtended();
        return DropBoxACL.isAllowed(this.operationsExtended, operation);
    }

    public boolean isAllowedExact(DropBoxAccessControlOperation operation) {
        this.initOperationsExtended();
        return DropBoxACL.isAllowedExact(this.operationsExtended, operation);
    }

    public DropBoxACL add(DropBoxAccessControlOperation ... operations) {
        this.addOperations(new HashSet<DropBoxAccessControlOperation>(Arrays.asList(operations)));
        return this;
    }

    public DropBoxACL remove(DropBoxAccessControlOperation ... operations) {
        this.removeOperations(new HashSet<DropBoxAccessControlOperation>(Arrays.asList(operations)));
        return this;
    }

    public Set<DropBoxAccessControlOperation> getOperations() {
        return new HashSet<DropBoxAccessControlOperation>(this.operations);
    }

    public Set<DropBoxAccessControlOperation> getOperationsExtended() {
        this.initOperationsExtended();
        return new HashSet<DropBoxAccessControlOperation>(this.operationsExtended);
    }

    public boolean isEmpty() {
        this.initOperationsExtended();
        return this.operationsExtended == null || this.operationsExtended.isEmpty() || this.operationsExtended.size() == 1 && this.operationsExtended.contains((Object)DropBoxAccessControlOperation.NONE);
    }

    @Override
    public DropBoxACL clone() {
        DropBoxACL result = new DropBoxACL();
        result.operations.addAll(this.operations);
        if (this.operationsExtended != null) {
            result.operationsExtended.addAll(this.operationsExtended);
        }
        return result;
    }

    private void addOperations(Set<DropBoxAccessControlOperation> operations) {
        if (operations.contains((Object)DropBoxAccessControlOperation.NONE) && operations.size() > 1) {
            throw new DropBoxException("ACL NONE cannot be combined with others.");
        }
        if (operations.contains((Object)DropBoxAccessControlOperation.NONE)) {
            this.remove(DropBoxAccessControlOperation.FULL);
            return;
        }
        this.operations.addAll(operations);
        if (this.operations.contains((Object)DropBoxAccessControlOperation.FULL)) {
            this.operations.clear();
            this.operations.add(DropBoxAccessControlOperation.FULL);
        }
        this.operationsExtended = new HashSet<DropBoxAccessControlOperation>();
        this.initOperationsExtended();
    }

    private void removeOperations(Set<DropBoxAccessControlOperation> operations) {
        operations.remove((Object)DropBoxAccessControlOperation.NONE);
        if (operations.size() == 0) {
            return;
        }
        if (operations.contains((Object)DropBoxAccessControlOperation.FULL)) {
            this.operations.clear();
        } else {
            if (this.operations.contains((Object)DropBoxAccessControlOperation.FULL)) {
                this.operations.remove((Object)DropBoxAccessControlOperation.FULL);
                this.operations.addAll(Arrays.asList(DropBoxAccessControlOperation.values()));
                this.operations.remove((Object)DropBoxAccessControlOperation.NONE);
                this.operations.remove((Object)DropBoxAccessControlOperation.FULL);
            }
            this.operations.removeAll(operations);
        }
        this.operationsExtended = new HashSet<DropBoxAccessControlOperation>();
        this.initOperationsExtended();
    }

    private void initOperationsExtended() {
        if (this.operationsExtended == null || this.operationsExtended.size() == 0) {
            this.operationsExtended = new HashSet<DropBoxAccessControlOperation>();
            this.operationsExtended.addAll(this.operations);
            if (this.operationsExtended.contains((Object)DropBoxAccessControlOperation.FULL)) {
                this.operationsExtended.addAll(FULL_EXTENDED);
                this.operationsExtended.remove((Object)DropBoxAccessControlOperation.NONE);
            }
        }
    }

    public static boolean isAllowed(Set<DropBoxAccessControlOperation> operations, DropBoxAccessControlOperation operation) {
        return operations.contains((Object)operation) || operation == DropBoxAccessControlOperation.WRITE && operations.contains((Object)DropBoxAccessControlOperation.PUBLIC) || operation == DropBoxAccessControlOperation.READ && operations.contains((Object)DropBoxAccessControlOperation.PUBLIC) || operation == DropBoxAccessControlOperation.LIST && operations.contains((Object)DropBoxAccessControlOperation.PUBLIC) || operation == DropBoxAccessControlOperation.LIST && (operations.contains((Object)DropBoxAccessControlOperation.WRITE) || operations.contains(operations.contains((Object)DropBoxAccessControlOperation.READ)));
    }

    public static boolean isAllowedExact(Set<DropBoxAccessControlOperation> operations, DropBoxAccessControlOperation operation) {
        return operations.contains((Object)operation);
    }
}

