/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.sdo;

import com.streamscape.Trace;
import com.streamscape.sdo.CloneableObject;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBoxACLContext;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.dropbox.FolderType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class DropBox
implements NamedObject,
CloneableObject {
    public static String LOCAL_FACTORY = "FSClient.Local";
    public static String LOCAL_FACTORY_1 = "local";
    public static String STFS_FACTORY = "STFSClient.Local";
    private String name;
    private String rootFolder;
    private String fsClientFactory = LOCAL_FACTORY;
    private boolean enabled;
    private String owner;
    private String nodeName;
    private DropBoxACLContext aclContext = new DropBoxACLContext();
    private List<DropBoxFolder> folders = new ArrayList<DropBoxFolder>();
    private DropBoxSharedResources sharedResources = new DropBoxSharedResources();

    public DropBox() {
    }

    public DropBox(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public DropBox setNodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRootFolder(String folder) {
        this.rootFolder = folder;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public String getFsClientFactory() {
        return this.fsClientFactory;
    }

    public void setFsClientFactory(String fsClientFactory) {
        this.fsClientFactory = fsClientFactory;
    }

    public DropBoxACLContext getAclContext() {
        if (this.aclContext == null) {
            this.aclContext = new DropBoxACLContext();
        }
        return this.aclContext.clone();
    }

    public void setAclContext(DropBoxACLContext aclContext) {
        this.aclContext = aclContext;
    }

    public synchronized List<DropBoxFolder> getFolders() {
        return new ArrayList<DropBoxFolder>(this.folders);
    }

    public synchronized List<DropBoxFolder> getFoldersByType(FolderType type) {
        return this.folders.stream().filter(desc -> desc.getType() == type).collect(Collectors.toList());
    }

    public synchronized DropBoxFolder getFolderByPath(String path) {
        for (DropBoxFolder folder : this.folders) {
            if (!folder.equalsPath(path)) continue;
            return folder;
        }
        return null;
    }

    public synchronized DropBoxFolder getFolderBest(String path) {
        DropBoxFolder result = null;
        for (DropBoxFolder folder : this.folders) {
            if (folder.equalsPath(path)) {
                return folder;
            }
            if (!folder.isParentOf(path)) continue;
            if (result == null) {
                result = folder;
                continue;
            }
            if (result.getPath().length() >= folder.getPath().length()) continue;
            result = folder;
        }
        return result;
    }

    public synchronized void setFolder(DropBoxFolder folder) {
        this.addFolder(folder, false);
    }

    public synchronized void addFolder(DropBoxFolder folder) {
        this.addFolder(folder, true);
    }

    public synchronized void addFolder(DropBoxFolder folder, boolean mergeType) {
        if (folder.getType() == null) {
            throw new IllegalArgumentException("Folder type is not set.");
        }
        DropBoxFolder current = this.getFolderByName(folder.getName());
        if (current != null) {
            if (mergeType) {
                if (current.getType() == FolderType.UPLOAD && folder.getType() == FolderType.DOWNLOAD) {
                    folder.setType(FolderType.UPLOAD_AND_DOWNLOAD);
                } else if (current.getType() == FolderType.DOWNLOAD && folder.getType() == FolderType.UPLOAD) {
                    folder.setType(FolderType.UPLOAD_AND_DOWNLOAD);
                }
            }
            this.removeFolderByName(folder.getName());
        }
        this.folders.add(folder);
    }

    public synchronized void clearFolders() {
        this.folders.clear();
    }

    public synchronized void validate() {
        if (this.rootFolder == null || this.rootFolder.length() == 0) {
            throw new IllegalArgumentException("Dropbox root folder is not set.");
        }
        for (DropBoxFolder folder : this.folders) {
            folder.setPath(DropBoxUtils.normalizePath(folder.getPath()));
        }
        TreeSet<DropBoxFolder> set = new TreeSet<DropBoxFolder>(Comparator.comparing(DropBoxFolder::getPath));
        set.addAll(this.folders);
        if (this.folders.size() != set.size()) {
            throw new IllegalArgumentException("Some DropBox folder descriptors have duplicate names.");
        }
        for (DropBoxFolder folder : this.folders) {
            if (folder.getType() != null) continue;
            Trace.logError(this, "Folder '{}' has null type. Set it to DISABLED.", this.getFolderURL(folder.getPath()));
            folder.setType(FolderType.DISABLED);
        }
    }

    public String getFolderURL(String folderPath) {
        return DropBoxUtils.getDropBoxURL(this.name, folderPath);
    }

    public DropBoxSharedResources getSharedResources() {
        if (this.sharedResources == null) {
            this.sharedResources = new DropBoxSharedResources();
        }
        return this.sharedResources;
    }

    @Override
    public DropBox clone() {
        DropBox result = new DropBox();
        result.name = this.name;
        result.rootFolder = this.rootFolder;
        result.fsClientFactory = this.fsClientFactory;
        result.owner = this.owner;
        result.nodeName = this.nodeName;
        result.enabled = this.enabled;
        result.aclContext = this.aclContext != null ? this.aclContext.clone() : new DropBoxACLContext();
        result.folders = new ArrayList<DropBoxFolder>(this.folders.size());
        for (DropBoxFolder folder : this.folders) {
            result.folders.add(folder.clone());
        }
        result.sharedResources = this.sharedResources != null ? this.sharedResources.clone() : new DropBoxSharedResources();
        return result;
    }

    public DropBoxFolder getFolderByName(String folderName) {
        return this.folders.stream().filter(f -> f.getName().equals(folderName)).findAny().orElse(null);
    }

    public void removeFolderByName(String folderName) {
        this.folders.removeAll(this.folders.stream().filter(f -> f.getName().equals(folderName)).collect(Collectors.toList()));
    }
}

