/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.EnumParameter;

public class SetPathNotationDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "set path notation";

    public SetPathNotationDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET PATH NOTATION").addParameter(new EnumParameter("notation", DropBoxAccessor.DropBoxPathNotation.class));
        this.syntax.setDescription("Sets path notation for this dropbox.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("notation").getValue());
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        DropBoxAccessor.DropBoxPathNotation notation = DropBoxAccessor.DropBoxPathNotation.valueOf(((Definition)statement).notation.toUpperCase());
        DropBox dropbox = callable.getDropBoxAccessor().getDropBox();
        if (notation == DropBoxAccessor.DropBoxPathNotation.OS && !DropBoxUtils.isOwner(dropbox, session.getOwnerName()) && !DropBoxUtils.hasUserAccess(dropbox, session.getOwnerName(), DropBoxAccessControlOperation.FULL)) {
            throw new DropBoxException("Only DropBox owner or user with FULL access can change notation to OS.");
        }
        callable.setDropBoxPathNotation(notation);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private String notation;

        protected Definition(String notation) {
            super(SetPathNotationDropBoxOperation.NAME);
            this.notation = notation;
        }
    }
}

