/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;

public class RmDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "rm";

    public RmDropBoxOperation() {
        this.createDSLSyntax(NAME);
        ((DSLStatementSyntax)this.syntax.setAction("RM").addModifier((AbstractModifier)new Modifier("-R").setRequired(false))).addParameter((AbstractParameter)new DropBoxPathParameter("path").setEndDelimiterToCommandEnd());
        this.syntax.setDescription("Remove files/directories.");
        this.syntax.setExamples("rm file1.txt\nrm -r myfolder\nrm *.xml\nrm somefolder/*.xml\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("-R"), statement.getParameter("path").getValue());
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        try (FileSystem fileSystem = accessor.createFileSystemOnPath(callable.getCurrentPath(), session.getOwnerName(), callable.getDropBoxPathNotation());){
            if (!fileSystem.delete(RmDropBoxOperation.unquote(((Definition)statement).path), ((Definition)statement).recursively)) {
                throw new Exception("Failed to delete file or directory.");
            }
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private boolean recursively;
        private final String path;

        protected Definition(boolean recursively, String path) {
            super(RmDropBoxOperation.NAME);
            this.recursively = recursively;
            this.path = path;
        }
    }
}

