/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;

public class RenameDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "rename";

    public RenameDropBoxOperation() {
        this.createDSLSyntax(NAME);
        ((DSLStatementSyntax)this.syntax.setAction("RENAME").addParameter(new DropBoxPathParameter("from"))).addParameter(new DropBoxPathParameter("to"));
        this.syntax.setDescription("Renames the file.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("from").getValue(), statement.getParameter("to").getValue());
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        try (FileSystem fileSystem = accessor.createFileSystemOnPath(callable.getCurrentPath(), session.getOwnerName(), callable.getDropBoxPathNotation());){
            fileSystem.rename(RenameDropBoxOperation.unquote(((Definition)statement).from), RenameDropBoxOperation.unquote(((Definition)statement).to));
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private final String from;
        private final String to;

        protected Definition(String from, String to) {
            super(RenameDropBoxOperation.NAME);
            this.from = from;
            this.to = to;
        }
    }
}

